/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.SubnetAssociation;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayMulticastDomainAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayMulticastDomainAssociation> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAttachmentId").getter(TransitGatewayMulticastDomainAssociation.getter(TransitGatewayMulticastDomainAssociation::transitGatewayAttachmentId)).setter(TransitGatewayMulticastDomainAssociation.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("transitGatewayAttachmentId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(TransitGatewayMulticastDomainAssociation.getter(TransitGatewayMulticastDomainAssociation::resourceId)).setter(TransitGatewayMulticastDomainAssociation.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(TransitGatewayMulticastDomainAssociation.getter(TransitGatewayMulticastDomainAssociation::resourceTypeAsString)).setter(TransitGatewayMulticastDomainAssociation.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwnerId").getter(TransitGatewayMulticastDomainAssociation.getter(TransitGatewayMulticastDomainAssociation::resourceOwnerId)).setter(TransitGatewayMulticastDomainAssociation.setter(Builder::resourceOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerId").unmarshallLocationName("resourceOwnerId").build()}).build();
    private static final SdkField<SubnetAssociation> SUBNET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Subnet").getter(TransitGatewayMulticastDomainAssociation.getter(TransitGatewayMulticastDomainAssociation::subnet)).setter(TransitGatewayMulticastDomainAssociation.setter(Builder::subnet)).constructor(SubnetAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnet").unmarshallLocationName("subnet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_OWNER_ID_FIELD, SUBNET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transitGatewayAttachmentId;
    private final String resourceId;
    private final String resourceType;
    private final String resourceOwnerId;
    private final SubnetAssociation subnet;

    private TransitGatewayMulticastDomainAssociation(BuilderImpl builder) {
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.subnet = builder.subnet;
    }

    public String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public TransitGatewayAttachmentResourceType resourceType() {
        return TransitGatewayAttachmentResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public String resourceOwnerId() {
        return this.resourceOwnerId;
    }

    public SubnetAssociation subnet() {
        return this.subnet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayMulticastDomainAssociation)) {
            return false;
        }
        TransitGatewayMulticastDomainAssociation other = (TransitGatewayMulticastDomainAssociation)obj;
        return Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceOwnerId(), other.resourceOwnerId()) && Objects.equals(this.subnet(), other.subnet());
    }

    public String toString() {
        return ToString.builder((String)"TransitGatewayMulticastDomainAssociation").add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceOwnerId", (Object)this.resourceOwnerId()).add("Subnet", (Object)this.subnet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceOwnerId": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerId()));
            }
            case "Subnet": {
                return Optional.ofNullable(clazz.cast(this.subnet()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayMulticastDomainAssociation, T> g) {
        return obj -> g.apply((TransitGatewayMulticastDomainAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayAttachmentId;
        private String resourceId;
        private String resourceType;
        private String resourceOwnerId;
        private SubnetAssociation subnet;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayMulticastDomainAssociation model) {
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.resourceOwnerId(model.resourceOwnerId);
            this.subnet(model.subnet);
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TransitGatewayAttachmentResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceOwnerId() {
            return this.resourceOwnerId;
        }

        @Override
        public final Builder resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public final void setResourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
        }

        public final SubnetAssociation.Builder getSubnet() {
            return this.subnet != null ? this.subnet.toBuilder() : null;
        }

        @Override
        public final Builder subnet(SubnetAssociation subnet) {
            this.subnet = subnet;
            return this;
        }

        public final void setSubnet(SubnetAssociation.BuilderImpl subnet) {
            this.subnet = subnet != null ? subnet.build() : null;
        }

        public TransitGatewayMulticastDomainAssociation build() {
            return new TransitGatewayMulticastDomainAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayMulticastDomainAssociation> {
        public Builder transitGatewayAttachmentId(String var1);

        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(TransitGatewayAttachmentResourceType var1);

        public Builder resourceOwnerId(String var1);

        public Builder subnet(SubnetAssociation var1);

        default public Builder subnet(Consumer<SubnetAssociation.Builder> subnet) {
            return this.subnet((SubnetAssociation)((SubnetAssociation.Builder)SubnetAssociation.builder().applyMutation(subnet)).build());
        }
    }
}

