/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyIdFormatRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyIdFormatRequest> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Resource").getter(ModifyIdFormatRequest.getter(ModifyIdFormatRequest::resource)).setter(ModifyIdFormatRequest.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").unmarshallLocationName("Resource").build()}).build();
    private static final SdkField<Boolean> USE_LONG_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseLongIds").getter(ModifyIdFormatRequest.getter(ModifyIdFormatRequest::useLongIds)).setter(ModifyIdFormatRequest.setter(Builder::useLongIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLongIds").unmarshallLocationName("UseLongIds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, USE_LONG_IDS_FIELD));
    private final String resource;
    private final Boolean useLongIds;

    private ModifyIdFormatRequest(BuilderImpl builder) {
        super(builder);
        this.resource = builder.resource;
        this.useLongIds = builder.useLongIds;
    }

    public String resource() {
        return this.resource;
    }

    public Boolean useLongIds() {
        return this.useLongIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.useLongIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIdFormatRequest)) {
            return false;
        }
        ModifyIdFormatRequest other = (ModifyIdFormatRequest)((Object)obj);
        return Objects.equals(this.resource(), other.resource()) && Objects.equals(this.useLongIds(), other.useLongIds());
    }

    public String toString() {
        return ToString.builder((String)"ModifyIdFormatRequest").add("Resource", (Object)this.resource()).add("UseLongIds", (Object)this.useLongIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "UseLongIds": {
                return Optional.ofNullable(clazz.cast(this.useLongIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyIdFormatRequest, T> g) {
        return obj -> g.apply((ModifyIdFormatRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String resource;
        private Boolean useLongIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIdFormatRequest model) {
            super(model);
            this.resource(model.resource);
            this.useLongIds(model.useLongIds);
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final Boolean getUseLongIds() {
            return this.useLongIds;
        }

        @Override
        public final Builder useLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
            return this;
        }

        public final void setUseLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIdFormatRequest build() {
            return new ModifyIdFormatRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyIdFormatRequest> {
        public Builder resource(String var1);

        public Builder useLongIds(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

