/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment;

public class DescribeTransitGatewayVpcAttachmentsIterable
implements SdkIterable<DescribeTransitGatewayVpcAttachmentsResponse> {
    private final Ec2Client client;
    private final DescribeTransitGatewayVpcAttachmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTransitGatewayVpcAttachmentsIterable(Ec2Client client, DescribeTransitGatewayVpcAttachmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeTransitGatewayVpcAttachmentsResponseFetcher();
    }

    public Iterator<DescribeTransitGatewayVpcAttachmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGatewayVpcAttachment> transitGatewayVpcAttachments() {
        Function<DescribeTransitGatewayVpcAttachmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayVpcAttachments() != null) {
                return response.transitGatewayVpcAttachments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTransitGatewayVpcAttachmentsResponseFetcher
    implements SyncPageFetcher<DescribeTransitGatewayVpcAttachmentsResponse> {
        private DescribeTransitGatewayVpcAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewayVpcAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTransitGatewayVpcAttachmentsResponse nextPage(DescribeTransitGatewayVpcAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewayVpcAttachmentsIterable.this.client.describeTransitGatewayVpcAttachments(DescribeTransitGatewayVpcAttachmentsIterable.this.firstRequest);
            }
            return DescribeTransitGatewayVpcAttachmentsIterable.this.client.describeTransitGatewayVpcAttachments((DescribeTransitGatewayVpcAttachmentsRequest)((Object)DescribeTransitGatewayVpcAttachmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

