/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.VpcEndpointIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RejectVpcEndpointConnectionsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, RejectVpcEndpointConnectionsRequest> {
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceId").getter(RejectVpcEndpointConnectionsRequest.getter(RejectVpcEndpointConnectionsRequest::serviceId)).setter(RejectVpcEndpointConnectionsRequest.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").unmarshallLocationName("ServiceId").build()}).build();
    private static final SdkField<List<String>> VPC_ENDPOINT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcEndpointIds").getter(RejectVpcEndpointConnectionsRequest.getter(RejectVpcEndpointConnectionsRequest::vpcEndpointIds)).setter(RejectVpcEndpointConnectionsRequest.setter(Builder::vpcEndpointIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").unmarshallLocationName("VpcEndpointId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ID_FIELD, VPC_ENDPOINT_IDS_FIELD));
    private final String serviceId;
    private final List<String> vpcEndpointIds;

    private RejectVpcEndpointConnectionsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceId = builder.serviceId;
        this.vpcEndpointIds = builder.vpcEndpointIds;
    }

    public String serviceId() {
        return this.serviceId;
    }

    public boolean hasVpcEndpointIds() {
        return this.vpcEndpointIds != null && !(this.vpcEndpointIds instanceof SdkAutoConstructList);
    }

    public List<String> vpcEndpointIds() {
        return this.vpcEndpointIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcEndpointIds() ? this.vpcEndpointIds() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectVpcEndpointConnectionsRequest)) {
            return false;
        }
        RejectVpcEndpointConnectionsRequest other = (RejectVpcEndpointConnectionsRequest)((Object)obj);
        return Objects.equals(this.serviceId(), other.serviceId()) && this.hasVpcEndpointIds() == other.hasVpcEndpointIds() && Objects.equals(this.vpcEndpointIds(), other.vpcEndpointIds());
    }

    public String toString() {
        return ToString.builder((String)"RejectVpcEndpointConnectionsRequest").add("ServiceId", (Object)this.serviceId()).add("VpcEndpointIds", this.hasVpcEndpointIds() ? this.vpcEndpointIds() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "VpcEndpointIds": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RejectVpcEndpointConnectionsRequest, T> g) {
        return obj -> g.apply((RejectVpcEndpointConnectionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String serviceId;
        private List<String> vpcEndpointIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RejectVpcEndpointConnectionsRequest model) {
            super(model);
            this.serviceId(model.serviceId);
            this.vpcEndpointIds(model.vpcEndpointIds);
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final Collection<String> getVpcEndpointIds() {
            if (this.vpcEndpointIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcEndpointIds;
        }

        @Override
        public final Builder vpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = VpcEndpointIdListCopier.copy(vpcEndpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointIds(String ... vpcEndpointIds) {
            this.vpcEndpointIds(Arrays.asList(vpcEndpointIds));
            return this;
        }

        public final void setVpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = VpcEndpointIdListCopier.copy(vpcEndpointIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RejectVpcEndpointConnectionsRequest build() {
            return new RejectVpcEndpointConnectionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RejectVpcEndpointConnectionsRequest> {
        public Builder serviceId(String var1);

        public Builder vpcEndpointIds(Collection<String> var1);

        public Builder vpcEndpointIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

