/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AssociatedRole;
import software.amazon.awssdk.services.ec2.model.AssociatedRolesListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssociatedEnclaveCertificateIamRolesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetAssociatedEnclaveCertificateIamRolesResponse> {
    private static final SdkField<List<AssociatedRole>> ASSOCIATED_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedRoles").getter(GetAssociatedEnclaveCertificateIamRolesResponse.getter(GetAssociatedEnclaveCertificateIamRolesResponse::associatedRoles)).setter(GetAssociatedEnclaveCertificateIamRolesResponse.setter(Builder::associatedRoles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRoleSet").unmarshallLocationName("associatedRoleSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedRole::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_ROLES_FIELD));
    private final List<AssociatedRole> associatedRoles;

    private GetAssociatedEnclaveCertificateIamRolesResponse(BuilderImpl builder) {
        super(builder);
        this.associatedRoles = builder.associatedRoles;
    }

    public boolean hasAssociatedRoles() {
        return this.associatedRoles != null && !(this.associatedRoles instanceof SdkAutoConstructList);
    }

    public List<AssociatedRole> associatedRoles() {
        return this.associatedRoles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedRoles() ? this.associatedRoles() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssociatedEnclaveCertificateIamRolesResponse)) {
            return false;
        }
        GetAssociatedEnclaveCertificateIamRolesResponse other = (GetAssociatedEnclaveCertificateIamRolesResponse)((Object)obj);
        return this.hasAssociatedRoles() == other.hasAssociatedRoles() && Objects.equals(this.associatedRoles(), other.associatedRoles());
    }

    public String toString() {
        return ToString.builder((String)"GetAssociatedEnclaveCertificateIamRolesResponse").add("AssociatedRoles", this.hasAssociatedRoles() ? this.associatedRoles() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociatedRoles": {
                return Optional.ofNullable(clazz.cast(this.associatedRoles()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssociatedEnclaveCertificateIamRolesResponse, T> g) {
        return obj -> g.apply((GetAssociatedEnclaveCertificateIamRolesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<AssociatedRole> associatedRoles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssociatedEnclaveCertificateIamRolesResponse model) {
            super(model);
            this.associatedRoles(model.associatedRoles);
        }

        public final Collection<AssociatedRole.Builder> getAssociatedRoles() {
            if (this.associatedRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedRoles != null ? (Collection)this.associatedRoles.stream().map(AssociatedRole::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associatedRoles(Collection<AssociatedRole> associatedRoles) {
            this.associatedRoles = AssociatedRolesListCopier.copy(associatedRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(AssociatedRole ... associatedRoles) {
            this.associatedRoles(Arrays.asList(associatedRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(Consumer<AssociatedRole.Builder> ... associatedRoles) {
            this.associatedRoles(Stream.of(associatedRoles).map(c -> (AssociatedRole)((AssociatedRole.Builder)AssociatedRole.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociatedRoles(Collection<AssociatedRole.BuilderImpl> associatedRoles) {
            this.associatedRoles = AssociatedRolesListCopier.copyFromBuilder(associatedRoles);
        }

        @Override
        public GetAssociatedEnclaveCertificateIamRolesResponse build() {
            return new GetAssociatedEnclaveCertificateIamRolesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssociatedEnclaveCertificateIamRolesResponse> {
        public Builder associatedRoles(Collection<AssociatedRole> var1);

        public Builder associatedRoles(AssociatedRole ... var1);

        public Builder associatedRoles(Consumer<AssociatedRole.Builder> ... var1);
    }
}

