/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CancelledSpotInstanceRequest;
import software.amazon.awssdk.services.ec2.model.CancelledSpotInstanceRequestListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelSpotInstanceRequestsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CancelSpotInstanceRequestsResponse> {
    private static final SdkField<List<CancelledSpotInstanceRequest>> CANCELLED_SPOT_INSTANCE_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CancelledSpotInstanceRequests").getter(CancelSpotInstanceRequestsResponse.getter(CancelSpotInstanceRequestsResponse::cancelledSpotInstanceRequests)).setter(CancelSpotInstanceRequestsResponse.setter(Builder::cancelledSpotInstanceRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestSet").unmarshallLocationName("spotInstanceRequestSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CancelledSpotInstanceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANCELLED_SPOT_INSTANCE_REQUESTS_FIELD));
    private final List<CancelledSpotInstanceRequest> cancelledSpotInstanceRequests;

    private CancelSpotInstanceRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.cancelledSpotInstanceRequests = builder.cancelledSpotInstanceRequests;
    }

    public boolean hasCancelledSpotInstanceRequests() {
        return this.cancelledSpotInstanceRequests != null && !(this.cancelledSpotInstanceRequests instanceof SdkAutoConstructList);
    }

    public List<CancelledSpotInstanceRequest> cancelledSpotInstanceRequests() {
        return this.cancelledSpotInstanceRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cancelledSpotInstanceRequests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotInstanceRequestsResponse)) {
            return false;
        }
        CancelSpotInstanceRequestsResponse other = (CancelSpotInstanceRequestsResponse)((Object)obj);
        return Objects.equals(this.cancelledSpotInstanceRequests(), other.cancelledSpotInstanceRequests());
    }

    public String toString() {
        return ToString.builder((String)"CancelSpotInstanceRequestsResponse").add("CancelledSpotInstanceRequests", this.cancelledSpotInstanceRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CancelledSpotInstanceRequests": {
                return Optional.ofNullable(clazz.cast(this.cancelledSpotInstanceRequests()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelSpotInstanceRequestsResponse, T> g) {
        return obj -> g.apply((CancelSpotInstanceRequestsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<CancelledSpotInstanceRequest> cancelledSpotInstanceRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotInstanceRequestsResponse model) {
            super(model);
            this.cancelledSpotInstanceRequests(model.cancelledSpotInstanceRequests);
        }

        public final Collection<CancelledSpotInstanceRequest.Builder> getCancelledSpotInstanceRequests() {
            return this.cancelledSpotInstanceRequests != null ? (Collection)this.cancelledSpotInstanceRequests.stream().map(CancelledSpotInstanceRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cancelledSpotInstanceRequests(Collection<CancelledSpotInstanceRequest> cancelledSpotInstanceRequests) {
            this.cancelledSpotInstanceRequests = CancelledSpotInstanceRequestListCopier.copy(cancelledSpotInstanceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancelledSpotInstanceRequests(CancelledSpotInstanceRequest ... cancelledSpotInstanceRequests) {
            this.cancelledSpotInstanceRequests(Arrays.asList(cancelledSpotInstanceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancelledSpotInstanceRequests(Consumer<CancelledSpotInstanceRequest.Builder> ... cancelledSpotInstanceRequests) {
            this.cancelledSpotInstanceRequests(Stream.of(cancelledSpotInstanceRequests).map(c -> (CancelledSpotInstanceRequest)((CancelledSpotInstanceRequest.Builder)CancelledSpotInstanceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCancelledSpotInstanceRequests(Collection<CancelledSpotInstanceRequest.BuilderImpl> cancelledSpotInstanceRequests) {
            this.cancelledSpotInstanceRequests = CancelledSpotInstanceRequestListCopier.copyFromBuilder(cancelledSpotInstanceRequests);
        }

        @Override
        public CancelSpotInstanceRequestsResponse build() {
            return new CancelSpotInstanceRequestsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelSpotInstanceRequestsResponse> {
        public Builder cancelledSpotInstanceRequests(Collection<CancelledSpotInstanceRequest> var1);

        public Builder cancelledSpotInstanceRequests(CancelledSpotInstanceRequest ... var1);

        public Builder cancelledSpotInstanceRequests(Consumer<CancelledSpotInstanceRequest.Builder> ... var1);
    }
}

