/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.LoadPermissionListRequestCopier;
import software.amazon.awssdk.services.ec2.model.LoadPermissionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadPermissionModifications
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoadPermissionModifications> {
    private static final SdkField<List<LoadPermissionRequest>> ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Add").getter(LoadPermissionModifications.getter(LoadPermissionModifications::add)).setter(LoadPermissionModifications.setter(Builder::add)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Add").unmarshallLocationName("Add").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadPermissionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<LoadPermissionRequest>> REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Remove").getter(LoadPermissionModifications.getter(LoadPermissionModifications::remove)).setter(LoadPermissionModifications.setter(Builder::remove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Remove").unmarshallLocationName("Remove").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadPermissionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_FIELD, REMOVE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<LoadPermissionRequest> add;
    private final List<LoadPermissionRequest> remove;

    private LoadPermissionModifications(BuilderImpl builder) {
        this.add = builder.add;
        this.remove = builder.remove;
    }

    public boolean hasAdd() {
        return this.add != null && !(this.add instanceof SdkAutoConstructList);
    }

    public List<LoadPermissionRequest> add() {
        return this.add;
    }

    public boolean hasRemove() {
        return this.remove != null && !(this.remove instanceof SdkAutoConstructList);
    }

    public List<LoadPermissionRequest> remove() {
        return this.remove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdd() ? this.add() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemove() ? this.remove() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadPermissionModifications)) {
            return false;
        }
        LoadPermissionModifications other = (LoadPermissionModifications)obj;
        return this.hasAdd() == other.hasAdd() && Objects.equals(this.add(), other.add()) && this.hasRemove() == other.hasRemove() && Objects.equals(this.remove(), other.remove());
    }

    public String toString() {
        return ToString.builder((String)"LoadPermissionModifications").add("Add", this.hasAdd() ? this.add() : null).add("Remove", this.hasRemove() ? this.remove() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Add": {
                return Optional.ofNullable(clazz.cast(this.add()));
            }
            case "Remove": {
                return Optional.ofNullable(clazz.cast(this.remove()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadPermissionModifications, T> g) {
        return obj -> g.apply((LoadPermissionModifications)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LoadPermissionRequest> add = DefaultSdkAutoConstructList.getInstance();
        private List<LoadPermissionRequest> remove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadPermissionModifications model) {
            this.add(model.add);
            this.remove(model.remove);
        }

        public final Collection<LoadPermissionRequest.Builder> getAdd() {
            if (this.add instanceof SdkAutoConstructList) {
                return null;
            }
            return this.add != null ? (Collection)this.add.stream().map(LoadPermissionRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder add(Collection<LoadPermissionRequest> add) {
            this.add = LoadPermissionListRequestCopier.copy(add);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(LoadPermissionRequest ... add) {
            this.add(Arrays.asList(add));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(Consumer<LoadPermissionRequest.Builder> ... add) {
            this.add(Stream.of(add).map(c -> (LoadPermissionRequest)((LoadPermissionRequest.Builder)LoadPermissionRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdd(Collection<LoadPermissionRequest.BuilderImpl> add) {
            this.add = LoadPermissionListRequestCopier.copyFromBuilder(add);
        }

        public final Collection<LoadPermissionRequest.Builder> getRemove() {
            if (this.remove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.remove != null ? (Collection)this.remove.stream().map(LoadPermissionRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remove(Collection<LoadPermissionRequest> remove) {
            this.remove = LoadPermissionListRequestCopier.copy(remove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remove(LoadPermissionRequest ... remove) {
            this.remove(Arrays.asList(remove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remove(Consumer<LoadPermissionRequest.Builder> ... remove) {
            this.remove(Stream.of(remove).map(c -> (LoadPermissionRequest)((LoadPermissionRequest.Builder)LoadPermissionRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRemove(Collection<LoadPermissionRequest.BuilderImpl> remove) {
            this.remove = LoadPermissionListRequestCopier.copyFromBuilder(remove);
        }

        public LoadPermissionModifications build() {
            return new LoadPermissionModifications(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoadPermissionModifications> {
        public Builder add(Collection<LoadPermissionRequest> var1);

        public Builder add(LoadPermissionRequest ... var1);

        public Builder add(Consumer<LoadPermissionRequest.Builder> ... var1);

        public Builder remove(Collection<LoadPermissionRequest> var1);

        public Builder remove(LoadPermissionRequest ... var1);

        public Builder remove(Consumer<LoadPermissionRequest.Builder> ... var1);
    }
}

