/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.MovingAddressStatus;
import software.amazon.awssdk.services.ec2.model.MovingAddressStatusSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMovingAddressesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeMovingAddressesResponse> {
    private static final SdkField<List<MovingAddressStatus>> MOVING_ADDRESS_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MovingAddressStatuses").getter(DescribeMovingAddressesResponse.getter(DescribeMovingAddressesResponse::movingAddressStatuses)).setter(DescribeMovingAddressesResponse.setter(Builder::movingAddressStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MovingAddressStatusSet").unmarshallLocationName("movingAddressStatusSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MovingAddressStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMovingAddressesResponse.getter(DescribeMovingAddressesResponse::nextToken)).setter(DescribeMovingAddressesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOVING_ADDRESS_STATUSES_FIELD, NEXT_TOKEN_FIELD));
    private final List<MovingAddressStatus> movingAddressStatuses;
    private final String nextToken;

    private DescribeMovingAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.movingAddressStatuses = builder.movingAddressStatuses;
        this.nextToken = builder.nextToken;
    }

    public boolean hasMovingAddressStatuses() {
        return this.movingAddressStatuses != null && !(this.movingAddressStatuses instanceof SdkAutoConstructList);
    }

    public List<MovingAddressStatus> movingAddressStatuses() {
        return this.movingAddressStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.movingAddressStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMovingAddressesResponse)) {
            return false;
        }
        DescribeMovingAddressesResponse other = (DescribeMovingAddressesResponse)((Object)obj);
        return Objects.equals(this.movingAddressStatuses(), other.movingAddressStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMovingAddressesResponse").add("MovingAddressStatuses", this.movingAddressStatuses()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MovingAddressStatuses": {
                return Optional.ofNullable(clazz.cast(this.movingAddressStatuses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMovingAddressesResponse, T> g) {
        return obj -> g.apply((DescribeMovingAddressesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<MovingAddressStatus> movingAddressStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMovingAddressesResponse model) {
            super(model);
            this.movingAddressStatuses(model.movingAddressStatuses);
            this.nextToken(model.nextToken);
        }

        public final Collection<MovingAddressStatus.Builder> getMovingAddressStatuses() {
            return this.movingAddressStatuses != null ? (Collection)this.movingAddressStatuses.stream().map(MovingAddressStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder movingAddressStatuses(Collection<MovingAddressStatus> movingAddressStatuses) {
            this.movingAddressStatuses = MovingAddressStatusSetCopier.copy(movingAddressStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder movingAddressStatuses(MovingAddressStatus ... movingAddressStatuses) {
            this.movingAddressStatuses(Arrays.asList(movingAddressStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder movingAddressStatuses(Consumer<MovingAddressStatus.Builder> ... movingAddressStatuses) {
            this.movingAddressStatuses(Stream.of(movingAddressStatuses).map(c -> (MovingAddressStatus)((MovingAddressStatus.Builder)MovingAddressStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMovingAddressStatuses(Collection<MovingAddressStatus.BuilderImpl> movingAddressStatuses) {
            this.movingAddressStatuses = MovingAddressStatusSetCopier.copyFromBuilder(movingAddressStatuses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMovingAddressesResponse build() {
            return new DescribeMovingAddressesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMovingAddressesResponse> {
        public Builder movingAddressStatuses(Collection<MovingAddressStatus> var1);

        public Builder movingAddressStatuses(MovingAddressStatus ... var1);

        public Builder movingAddressStatuses(Consumer<MovingAddressStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

