/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityReservation;
import software.amazon.awssdk.services.ec2.model.CapacityReservationSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCapacityReservationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeCapacityReservationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeCapacityReservationsResponse.getter(DescribeCapacityReservationsResponse::nextToken)).setter(DescribeCapacityReservationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<CapacityReservation>> CAPACITY_RESERVATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityReservations").getter(DescribeCapacityReservationsResponse.getter(DescribeCapacityReservationsResponse::capacityReservations)).setter(DescribeCapacityReservationsResponse.setter(Builder::capacityReservations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSet").unmarshallLocationName("capacityReservationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityReservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CAPACITY_RESERVATIONS_FIELD));
    private final String nextToken;
    private final List<CapacityReservation> capacityReservations;

    private DescribeCapacityReservationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.capacityReservations = builder.capacityReservations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasCapacityReservations() {
        return this.capacityReservations != null && !(this.capacityReservations instanceof SdkAutoConstructList);
    }

    public List<CapacityReservation> capacityReservations() {
        return this.capacityReservations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityReservationsResponse)) {
            return false;
        }
        DescribeCapacityReservationsResponse other = (DescribeCapacityReservationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.capacityReservations(), other.capacityReservations());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCapacityReservationsResponse").add("NextToken", (Object)this.nextToken()).add("CapacityReservations", this.capacityReservations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CapacityReservations": {
                return Optional.ofNullable(clazz.cast(this.capacityReservations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityReservationsResponse, T> g) {
        return obj -> g.apply((DescribeCapacityReservationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CapacityReservation> capacityReservations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityReservationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.capacityReservations(model.capacityReservations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<CapacityReservation.Builder> getCapacityReservations() {
            return this.capacityReservations != null ? (Collection)this.capacityReservations.stream().map(CapacityReservation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder capacityReservations(Collection<CapacityReservation> capacityReservations) {
            this.capacityReservations = CapacityReservationSetCopier.copy(capacityReservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservations(CapacityReservation ... capacityReservations) {
            this.capacityReservations(Arrays.asList(capacityReservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservations(Consumer<CapacityReservation.Builder> ... capacityReservations) {
            this.capacityReservations(Stream.of(capacityReservations).map(c -> (CapacityReservation)((CapacityReservation.Builder)CapacityReservation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCapacityReservations(Collection<CapacityReservation.BuilderImpl> capacityReservations) {
            this.capacityReservations = CapacityReservationSetCopier.copyFromBuilder(capacityReservations);
        }

        @Override
        public DescribeCapacityReservationsResponse build() {
            return new DescribeCapacityReservationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCapacityReservationsResponse> {
        public Builder nextToken(String var1);

        public Builder capacityReservations(Collection<CapacityReservation> var1);

        public Builder capacityReservations(CapacityReservation ... var1);

        public Builder capacityReservations(Consumer<CapacityReservation.Builder> ... var1);
    }
}

