/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.PermissionGroup;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVolumePermission
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateVolumePermission> {
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Group").getter(CreateVolumePermission.getter(CreateVolumePermission::groupAsString)).setter(CreateVolumePermission.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").unmarshallLocationName("group").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(CreateVolumePermission.getter(CreateVolumePermission::userId)).setter(CreateVolumePermission.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").unmarshallLocationName("userId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, USER_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String group;
    private final String userId;

    private CreateVolumePermission(BuilderImpl builder) {
        this.group = builder.group;
        this.userId = builder.userId;
    }

    public PermissionGroup group() {
        return PermissionGroup.fromValue(this.group);
    }

    public String groupAsString() {
        return this.group;
    }

    public String userId() {
        return this.userId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVolumePermission)) {
            return false;
        }
        CreateVolumePermission other = (CreateVolumePermission)obj;
        return Objects.equals(this.groupAsString(), other.groupAsString()) && Objects.equals(this.userId(), other.userId());
    }

    public String toString() {
        return ToString.builder((String)"CreateVolumePermission").add("Group", (Object)this.groupAsString()).add("UserId", (Object)this.userId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.groupAsString()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVolumePermission, T> g) {
        return obj -> g.apply((CreateVolumePermission)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String group;
        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVolumePermission model) {
            this.group(model.group);
            this.userId(model.userId);
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public final Builder group(PermissionGroup group) {
            this.group(group == null ? null : group.toString());
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public CreateVolumePermission build() {
            return new CreateVolumePermission(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateVolumePermission> {
        public Builder group(String var1);

        public Builder group(PermissionGroup var1);

        public Builder userId(String var1);
    }
}

