/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.VpcEndpointRouteTableIdListCopier;
import software.amazon.awssdk.services.ec2.model.VpcEndpointSecurityGroupIdListCopier;
import software.amazon.awssdk.services.ec2.model.VpcEndpointSubnetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpcEndpointRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVpcEndpointRequest> {
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::vpcEndpointId)).setter(ModifyVpcEndpointRequest.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").unmarshallLocationName("VpcEndpointId").build()}).build();
    private static final SdkField<Boolean> RESET_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::resetPolicy)).setter(ModifyVpcEndpointRequest.setter(Builder::resetPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResetPolicy").unmarshallLocationName("ResetPolicy").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::policyDocument)).setter(ModifyVpcEndpointRequest.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").unmarshallLocationName("PolicyDocument").build()}).build();
    private static final SdkField<List<String>> ADD_ROUTE_TABLE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::addRouteTableIds)).setter(ModifyVpcEndpointRequest.setter(Builder::addRouteTableIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddRouteTableId").unmarshallLocationName("AddRouteTableId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_ROUTE_TABLE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::removeRouteTableIds)).setter(ModifyVpcEndpointRequest.setter(Builder::removeRouteTableIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveRouteTableId").unmarshallLocationName("RemoveRouteTableId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADD_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::addSubnetIds)).setter(ModifyVpcEndpointRequest.setter(Builder::addSubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSubnetId").unmarshallLocationName("AddSubnetId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::removeSubnetIds)).setter(ModifyVpcEndpointRequest.setter(Builder::removeSubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSubnetId").unmarshallLocationName("RemoveSubnetId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADD_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::addSecurityGroupIds)).setter(ModifyVpcEndpointRequest.setter(Builder::addSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSecurityGroupId").unmarshallLocationName("AddSecurityGroupId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::removeSecurityGroupIds)).setter(ModifyVpcEndpointRequest.setter(Builder::removeSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSecurityGroupId").unmarshallLocationName("RemoveSecurityGroupId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PRIVATE_DNS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ModifyVpcEndpointRequest.getter(ModifyVpcEndpointRequest::privateDnsEnabled)).setter(ModifyVpcEndpointRequest.setter(Builder::privateDnsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsEnabled").unmarshallLocationName("PrivateDnsEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_ID_FIELD, RESET_POLICY_FIELD, POLICY_DOCUMENT_FIELD, ADD_ROUTE_TABLE_IDS_FIELD, REMOVE_ROUTE_TABLE_IDS_FIELD, ADD_SUBNET_IDS_FIELD, REMOVE_SUBNET_IDS_FIELD, ADD_SECURITY_GROUP_IDS_FIELD, REMOVE_SECURITY_GROUP_IDS_FIELD, PRIVATE_DNS_ENABLED_FIELD));
    private final String vpcEndpointId;
    private final Boolean resetPolicy;
    private final String policyDocument;
    private final List<String> addRouteTableIds;
    private final List<String> removeRouteTableIds;
    private final List<String> addSubnetIds;
    private final List<String> removeSubnetIds;
    private final List<String> addSecurityGroupIds;
    private final List<String> removeSecurityGroupIds;
    private final Boolean privateDnsEnabled;

    private ModifyVpcEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointId = builder.vpcEndpointId;
        this.resetPolicy = builder.resetPolicy;
        this.policyDocument = builder.policyDocument;
        this.addRouteTableIds = builder.addRouteTableIds;
        this.removeRouteTableIds = builder.removeRouteTableIds;
        this.addSubnetIds = builder.addSubnetIds;
        this.removeSubnetIds = builder.removeSubnetIds;
        this.addSecurityGroupIds = builder.addSecurityGroupIds;
        this.removeSecurityGroupIds = builder.removeSecurityGroupIds;
        this.privateDnsEnabled = builder.privateDnsEnabled;
    }

    public String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public Boolean resetPolicy() {
        return this.resetPolicy;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    public boolean hasAddRouteTableIds() {
        return this.addRouteTableIds != null && !(this.addRouteTableIds instanceof SdkAutoConstructList);
    }

    public List<String> addRouteTableIds() {
        return this.addRouteTableIds;
    }

    public boolean hasRemoveRouteTableIds() {
        return this.removeRouteTableIds != null && !(this.removeRouteTableIds instanceof SdkAutoConstructList);
    }

    public List<String> removeRouteTableIds() {
        return this.removeRouteTableIds;
    }

    public boolean hasAddSubnetIds() {
        return this.addSubnetIds != null && !(this.addSubnetIds instanceof SdkAutoConstructList);
    }

    public List<String> addSubnetIds() {
        return this.addSubnetIds;
    }

    public boolean hasRemoveSubnetIds() {
        return this.removeSubnetIds != null && !(this.removeSubnetIds instanceof SdkAutoConstructList);
    }

    public List<String> removeSubnetIds() {
        return this.removeSubnetIds;
    }

    public boolean hasAddSecurityGroupIds() {
        return this.addSecurityGroupIds != null && !(this.addSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> addSecurityGroupIds() {
        return this.addSecurityGroupIds;
    }

    public boolean hasRemoveSecurityGroupIds() {
        return this.removeSecurityGroupIds != null && !(this.removeSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> removeSecurityGroupIds() {
        return this.removeSecurityGroupIds;
    }

    public Boolean privateDnsEnabled() {
        return this.privateDnsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resetPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.addRouteTableIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeRouteTableIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.addSubnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeSubnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.addSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointRequest)) {
            return false;
        }
        ModifyVpcEndpointRequest other = (ModifyVpcEndpointRequest)((Object)obj);
        return Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.resetPolicy(), other.resetPolicy()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.addRouteTableIds(), other.addRouteTableIds()) && Objects.equals(this.removeRouteTableIds(), other.removeRouteTableIds()) && Objects.equals(this.addSubnetIds(), other.addSubnetIds()) && Objects.equals(this.removeSubnetIds(), other.removeSubnetIds()) && Objects.equals(this.addSecurityGroupIds(), other.addSecurityGroupIds()) && Objects.equals(this.removeSecurityGroupIds(), other.removeSecurityGroupIds()) && Objects.equals(this.privateDnsEnabled(), other.privateDnsEnabled());
    }

    public String toString() {
        return ToString.builder((String)"ModifyVpcEndpointRequest").add("VpcEndpointId", (Object)this.vpcEndpointId()).add("ResetPolicy", (Object)this.resetPolicy()).add("PolicyDocument", (Object)this.policyDocument()).add("AddRouteTableIds", this.addRouteTableIds()).add("RemoveRouteTableIds", this.removeRouteTableIds()).add("AddSubnetIds", this.addSubnetIds()).add("RemoveSubnetIds", this.removeSubnetIds()).add("AddSecurityGroupIds", this.addSecurityGroupIds()).add("RemoveSecurityGroupIds", this.removeSecurityGroupIds()).add("PrivateDnsEnabled", (Object)this.privateDnsEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "ResetPolicy": {
                return Optional.ofNullable(clazz.cast(this.resetPolicy()));
            }
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "AddRouteTableIds": {
                return Optional.ofNullable(clazz.cast(this.addRouteTableIds()));
            }
            case "RemoveRouteTableIds": {
                return Optional.ofNullable(clazz.cast(this.removeRouteTableIds()));
            }
            case "AddSubnetIds": {
                return Optional.ofNullable(clazz.cast(this.addSubnetIds()));
            }
            case "RemoveSubnetIds": {
                return Optional.ofNullable(clazz.cast(this.removeSubnetIds()));
            }
            case "AddSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.addSecurityGroupIds()));
            }
            case "RemoveSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.removeSecurityGroupIds()));
            }
            case "PrivateDnsEnabled": {
                return Optional.ofNullable(clazz.cast(this.privateDnsEnabled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointRequest, T> g) {
        return obj -> g.apply((ModifyVpcEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String vpcEndpointId;
        private Boolean resetPolicy;
        private String policyDocument;
        private List<String> addRouteTableIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeRouteTableIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> addSubnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeSubnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> addSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean privateDnsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointRequest model) {
            super(model);
            this.vpcEndpointId(model.vpcEndpointId);
            this.resetPolicy(model.resetPolicy);
            this.policyDocument(model.policyDocument);
            this.addRouteTableIds(model.addRouteTableIds);
            this.removeRouteTableIds(model.removeRouteTableIds);
            this.addSubnetIds(model.addSubnetIds);
            this.removeSubnetIds(model.removeSubnetIds);
            this.addSecurityGroupIds(model.addSecurityGroupIds);
            this.removeSecurityGroupIds(model.removeSecurityGroupIds);
            this.privateDnsEnabled(model.privateDnsEnabled);
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final Boolean getResetPolicy() {
            return this.resetPolicy;
        }

        @Override
        public final Builder resetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
            return this;
        }

        public final void setResetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Collection<String> getAddRouteTableIds() {
            return this.addRouteTableIds;
        }

        @Override
        public final Builder addRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(addRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addRouteTableIds(String ... addRouteTableIds) {
            this.addRouteTableIds(Arrays.asList(addRouteTableIds));
            return this;
        }

        public final void setAddRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(addRouteTableIds);
        }

        public final Collection<String> getRemoveRouteTableIds() {
            return this.removeRouteTableIds;
        }

        @Override
        public final Builder removeRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(removeRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeRouteTableIds(String ... removeRouteTableIds) {
            this.removeRouteTableIds(Arrays.asList(removeRouteTableIds));
            return this;
        }

        public final void setRemoveRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(removeRouteTableIds);
        }

        public final Collection<String> getAddSubnetIds() {
            return this.addSubnetIds;
        }

        @Override
        public final Builder addSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = VpcEndpointSubnetIdListCopier.copy(addSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSubnetIds(String ... addSubnetIds) {
            this.addSubnetIds(Arrays.asList(addSubnetIds));
            return this;
        }

        public final void setAddSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = VpcEndpointSubnetIdListCopier.copy(addSubnetIds);
        }

        public final Collection<String> getRemoveSubnetIds() {
            return this.removeSubnetIds;
        }

        @Override
        public final Builder removeSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = VpcEndpointSubnetIdListCopier.copy(removeSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSubnetIds(String ... removeSubnetIds) {
            this.removeSubnetIds(Arrays.asList(removeSubnetIds));
            return this;
        }

        public final void setRemoveSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = VpcEndpointSubnetIdListCopier.copy(removeSubnetIds);
        }

        public final Collection<String> getAddSecurityGroupIds() {
            return this.addSecurityGroupIds;
        }

        @Override
        public final Builder addSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(addSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSecurityGroupIds(String ... addSecurityGroupIds) {
            this.addSecurityGroupIds(Arrays.asList(addSecurityGroupIds));
            return this;
        }

        public final void setAddSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(addSecurityGroupIds);
        }

        public final Collection<String> getRemoveSecurityGroupIds() {
            return this.removeSecurityGroupIds;
        }

        @Override
        public final Builder removeSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(removeSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSecurityGroupIds(String ... removeSecurityGroupIds) {
            this.removeSecurityGroupIds(Arrays.asList(removeSecurityGroupIds));
            return this;
        }

        public final void setRemoveSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(removeSecurityGroupIds);
        }

        public final Boolean getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        @Override
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointRequest build() {
            return new ModifyVpcEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVpcEndpointRequest> {
        public Builder vpcEndpointId(String var1);

        public Builder resetPolicy(Boolean var1);

        public Builder policyDocument(String var1);

        public Builder addRouteTableIds(Collection<String> var1);

        public Builder addRouteTableIds(String ... var1);

        public Builder removeRouteTableIds(Collection<String> var1);

        public Builder removeRouteTableIds(String ... var1);

        public Builder addSubnetIds(Collection<String> var1);

        public Builder addSubnetIds(String ... var1);

        public Builder removeSubnetIds(Collection<String> var1);

        public Builder removeSubnetIds(String ... var1);

        public Builder addSecurityGroupIds(Collection<String> var1);

        public Builder addSecurityGroupIds(String ... var1);

        public Builder removeSecurityGroupIds(Collection<String> var1);

        public Builder removeSecurityGroupIds(String ... var1);

        public Builder privateDnsEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

