/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DnsEntry;
import software.amazon.awssdk.services.ec2.model.DnsEntrySetCopier;
import software.amazon.awssdk.services.ec2.model.State;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcEndpointConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcEndpointConnection> {
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpcEndpointConnection.getter(VpcEndpointConnection::serviceId)).setter(VpcEndpointConnection.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").unmarshallLocationName("serviceId").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpcEndpointConnection.getter(VpcEndpointConnection::vpcEndpointId)).setter(VpcEndpointConnection.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").unmarshallLocationName("vpcEndpointId").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpcEndpointConnection.getter(VpcEndpointConnection::vpcEndpointOwner)).setter(VpcEndpointConnection.setter(Builder::vpcEndpointOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointOwner").unmarshallLocationName("vpcEndpointOwner").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VpcEndpointConnection.getter(VpcEndpointConnection::vpcEndpointStateAsString)).setter(VpcEndpointConnection.setter(Builder::vpcEndpointState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointState").unmarshallLocationName("vpcEndpointState").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(VpcEndpointConnection.getter(VpcEndpointConnection::creationTimestamp)).setter(VpcEndpointConnection.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").unmarshallLocationName("creationTimestamp").build()}).build();
    private static final SdkField<List<DnsEntry>> DNS_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpcEndpointConnection.getter(VpcEndpointConnection::dnsEntries)).setter(VpcEndpointConnection.setter(Builder::dnsEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsEntrySet").unmarshallLocationName("dnsEntrySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DnsEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpcEndpointConnection.getter(VpcEndpointConnection::networkLoadBalancerArns)).setter(VpcEndpointConnection.setter(Builder::networkLoadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkLoadBalancerArnSet").unmarshallLocationName("networkLoadBalancerArnSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ID_FIELD, VPC_ENDPOINT_ID_FIELD, VPC_ENDPOINT_OWNER_FIELD, VPC_ENDPOINT_STATE_FIELD, CREATION_TIMESTAMP_FIELD, DNS_ENTRIES_FIELD, NETWORK_LOAD_BALANCER_ARNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceId;
    private final String vpcEndpointId;
    private final String vpcEndpointOwner;
    private final String vpcEndpointState;
    private final Instant creationTimestamp;
    private final List<DnsEntry> dnsEntries;
    private final List<String> networkLoadBalancerArns;

    private VpcEndpointConnection(BuilderImpl builder) {
        this.serviceId = builder.serviceId;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcEndpointOwner = builder.vpcEndpointOwner;
        this.vpcEndpointState = builder.vpcEndpointState;
        this.creationTimestamp = builder.creationTimestamp;
        this.dnsEntries = builder.dnsEntries;
        this.networkLoadBalancerArns = builder.networkLoadBalancerArns;
    }

    public String serviceId() {
        return this.serviceId;
    }

    public String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public String vpcEndpointOwner() {
        return this.vpcEndpointOwner;
    }

    public State vpcEndpointState() {
        return State.fromValue(this.vpcEndpointState);
    }

    public String vpcEndpointStateAsString() {
        return this.vpcEndpointState;
    }

    public Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public boolean hasDnsEntries() {
        return this.dnsEntries != null && !(this.dnsEntries instanceof SdkAutoConstructList);
    }

    public List<DnsEntry> dnsEntries() {
        return this.dnsEntries;
    }

    public boolean hasNetworkLoadBalancerArns() {
        return this.networkLoadBalancerArns != null && !(this.networkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    public List<String> networkLoadBalancerArns() {
        return this.networkLoadBalancerArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkLoadBalancerArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpointConnection)) {
            return false;
        }
        VpcEndpointConnection other = (VpcEndpointConnection)obj;
        return Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.vpcEndpointOwner(), other.vpcEndpointOwner()) && Objects.equals(this.vpcEndpointStateAsString(), other.vpcEndpointStateAsString()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.dnsEntries(), other.dnsEntries()) && Objects.equals(this.networkLoadBalancerArns(), other.networkLoadBalancerArns());
    }

    public String toString() {
        return ToString.builder((String)"VpcEndpointConnection").add("ServiceId", (Object)this.serviceId()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("VpcEndpointOwner", (Object)this.vpcEndpointOwner()).add("VpcEndpointState", (Object)this.vpcEndpointStateAsString()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("DnsEntries", this.dnsEntries()).add("NetworkLoadBalancerArns", this.networkLoadBalancerArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "VpcEndpointOwner": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointOwner()));
            }
            case "VpcEndpointState": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointStateAsString()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "DnsEntries": {
                return Optional.ofNullable(clazz.cast(this.dnsEntries()));
            }
            case "NetworkLoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.networkLoadBalancerArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcEndpointConnection, T> g) {
        return obj -> g.apply((VpcEndpointConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceId;
        private String vpcEndpointId;
        private String vpcEndpointOwner;
        private String vpcEndpointState;
        private Instant creationTimestamp;
        private List<DnsEntry> dnsEntries = DefaultSdkAutoConstructList.getInstance();
        private List<String> networkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpointConnection model) {
            this.serviceId(model.serviceId);
            this.vpcEndpointId(model.vpcEndpointId);
            this.vpcEndpointOwner(model.vpcEndpointOwner);
            this.vpcEndpointState(model.vpcEndpointState);
            this.creationTimestamp(model.creationTimestamp);
            this.dnsEntries(model.dnsEntries);
            this.networkLoadBalancerArns(model.networkLoadBalancerArns);
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final String getVpcEndpointOwner() {
            return this.vpcEndpointOwner;
        }

        @Override
        public final Builder vpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
            return this;
        }

        public final void setVpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
        }

        public final String getVpcEndpointState() {
            return this.vpcEndpointState;
        }

        @Override
        public final Builder vpcEndpointState(String vpcEndpointState) {
            this.vpcEndpointState = vpcEndpointState;
            return this;
        }

        @Override
        public final Builder vpcEndpointState(State vpcEndpointState) {
            this.vpcEndpointState(vpcEndpointState == null ? null : vpcEndpointState.toString());
            return this;
        }

        public final void setVpcEndpointState(String vpcEndpointState) {
            this.vpcEndpointState = vpcEndpointState;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final Collection<DnsEntry.Builder> getDnsEntries() {
            return this.dnsEntries != null ? (Collection)this.dnsEntries.stream().map(DnsEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dnsEntries(Collection<DnsEntry> dnsEntries) {
            this.dnsEntries = DnsEntrySetCopier.copy(dnsEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsEntries(DnsEntry ... dnsEntries) {
            this.dnsEntries(Arrays.asList(dnsEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsEntries(Consumer<DnsEntry.Builder> ... dnsEntries) {
            this.dnsEntries(Stream.of(dnsEntries).map(c -> (DnsEntry)((DnsEntry.Builder)DnsEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDnsEntries(Collection<DnsEntry.BuilderImpl> dnsEntries) {
            this.dnsEntries = DnsEntrySetCopier.copyFromBuilder(dnsEntries);
        }

        public final Collection<String> getNetworkLoadBalancerArns() {
            return this.networkLoadBalancerArns;
        }

        @Override
        public final Builder networkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = ValueStringListCopier.copy(networkLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkLoadBalancerArns(String ... networkLoadBalancerArns) {
            this.networkLoadBalancerArns(Arrays.asList(networkLoadBalancerArns));
            return this;
        }

        public final void setNetworkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = ValueStringListCopier.copy(networkLoadBalancerArns);
        }

        public VpcEndpointConnection build() {
            return new VpcEndpointConnection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcEndpointConnection> {
        public Builder serviceId(String var1);

        public Builder vpcEndpointId(String var1);

        public Builder vpcEndpointOwner(String var1);

        public Builder vpcEndpointState(String var1);

        public Builder vpcEndpointState(State var1);

        public Builder creationTimestamp(Instant var1);

        public Builder dnsEntries(Collection<DnsEntry> var1);

        public Builder dnsEntries(DnsEntry ... var1);

        public Builder dnsEntries(Consumer<DnsEntry.Builder> ... var1);

        public Builder networkLoadBalancerArns(Collection<String> var1);

        public Builder networkLoadBalancerArns(String ... var1);
    }
}

