/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceCreditSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceCreditSpecification> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceCreditSpecification.getter(InstanceCreditSpecification::instanceId)).setter(InstanceCreditSpecification.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> CPU_CREDITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceCreditSpecification.getter(InstanceCreditSpecification::cpuCredits)).setter(InstanceCreditSpecification.setter(Builder::cpuCredits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuCredits").unmarshallLocationName("cpuCredits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CPU_CREDITS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String cpuCredits;

    private InstanceCreditSpecification(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.cpuCredits = builder.cpuCredits;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String cpuCredits() {
        return this.cpuCredits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCredits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCreditSpecification)) {
            return false;
        }
        InstanceCreditSpecification other = (InstanceCreditSpecification)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.cpuCredits(), other.cpuCredits());
    }

    public String toString() {
        return ToString.builder((String)"InstanceCreditSpecification").add("InstanceId", (Object)this.instanceId()).add("CpuCredits", (Object)this.cpuCredits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "CpuCredits": {
                return Optional.ofNullable(clazz.cast(this.cpuCredits()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceCreditSpecification, T> g) {
        return obj -> g.apply((InstanceCreditSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String cpuCredits;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCreditSpecification model) {
            this.instanceId(model.instanceId);
            this.cpuCredits(model.cpuCredits);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getCpuCredits() {
            return this.cpuCredits;
        }

        @Override
        public final Builder cpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
            return this;
        }

        public final void setCpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
        }

        public InstanceCreditSpecification build() {
            return new InstanceCreditSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceCreditSpecification> {
        public Builder instanceId(String var1);

        public Builder cpuCredits(String var1);
    }
}

