/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.EventInformation;
import software.amazon.awssdk.services.ec2.model.FleetEventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HistoryRecordEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HistoryRecordEntry> {
    private static final SdkField<EventInformation> EVENT_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HistoryRecordEntry.getter(HistoryRecordEntry::eventInformation)).setter(HistoryRecordEntry.setter(Builder::eventInformation)).constructor(EventInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventInformation").unmarshallLocationName("eventInformation").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HistoryRecordEntry.getter(HistoryRecordEntry::eventTypeAsString)).setter(HistoryRecordEntry.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").unmarshallLocationName("eventType").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(HistoryRecordEntry.getter(HistoryRecordEntry::timestamp)).setter(HistoryRecordEntry.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").unmarshallLocationName("timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_INFORMATION_FIELD, EVENT_TYPE_FIELD, TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final EventInformation eventInformation;
    private final String eventType;
    private final Instant timestamp;

    private HistoryRecordEntry(BuilderImpl builder) {
        this.eventInformation = builder.eventInformation;
        this.eventType = builder.eventType;
        this.timestamp = builder.timestamp;
    }

    public EventInformation eventInformation() {
        return this.eventInformation;
    }

    public FleetEventType eventType() {
        return FleetEventType.fromValue(this.eventType);
    }

    public String eventTypeAsString() {
        return this.eventType;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoryRecordEntry)) {
            return false;
        }
        HistoryRecordEntry other = (HistoryRecordEntry)obj;
        return Objects.equals(this.eventInformation(), other.eventInformation()) && Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public String toString() {
        return ToString.builder((String)"HistoryRecordEntry").add("EventInformation", (Object)this.eventInformation()).add("EventType", (Object)this.eventTypeAsString()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventInformation": {
                return Optional.ofNullable(clazz.cast(this.eventInformation()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HistoryRecordEntry, T> g) {
        return obj -> g.apply((HistoryRecordEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EventInformation eventInformation;
        private String eventType;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoryRecordEntry model) {
            this.eventInformation(model.eventInformation);
            this.eventType(model.eventType);
            this.timestamp(model.timestamp);
        }

        public final EventInformation.Builder getEventInformation() {
            return this.eventInformation != null ? this.eventInformation.toBuilder() : null;
        }

        @Override
        public final Builder eventInformation(EventInformation eventInformation) {
            this.eventInformation = eventInformation;
            return this;
        }

        public final void setEventInformation(EventInformation.BuilderImpl eventInformation) {
            this.eventInformation = eventInformation != null ? eventInformation.build() : null;
        }

        public final String getEventType() {
            return this.eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(FleetEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public HistoryRecordEntry build() {
            return new HistoryRecordEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HistoryRecordEntry> {
        public Builder eventInformation(EventInformation var1);

        default public Builder eventInformation(Consumer<EventInformation.Builder> eventInformation) {
            return this.eventInformation((EventInformation)((EventInformation.Builder)EventInformation.builder().applyMutation(eventInformation)).build());
        }

        public Builder eventType(String var1);

        public Builder eventType(FleetEventType var1);

        public Builder timestamp(Instant var1);
    }
}

