/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.FpgaImageState;
import software.amazon.awssdk.services.ec2.model.PciId;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FpgaImage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FpgaImage> {
    private static final SdkField<String> FPGA_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FpgaImage.getter(FpgaImage::fpgaImageId)).setter(FpgaImage.setter(Builder::fpgaImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageId").unmarshallLocationName("fpgaImageId").build()}).build();
    private static final SdkField<String> FPGA_IMAGE_GLOBAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FpgaImage.getter(FpgaImage::fpgaImageGlobalId)).setter(FpgaImage.setter(Builder::fpgaImageGlobalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageGlobalId").unmarshallLocationName("fpgaImageGlobalId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FpgaImage.getter(FpgaImage::name)).setter(FpgaImage.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FpgaImage.getter(FpgaImage::description)).setter(FpgaImage.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> SHELL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FpgaImage.getter(FpgaImage::shellVersion)).setter(FpgaImage.setter(Builder::shellVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShellVersion").unmarshallLocationName("shellVersion").build()}).build();
    private static final SdkField<PciId> PCI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(FpgaImage.getter(FpgaImage::pciId)).setter(FpgaImage.setter(Builder::pciId)).constructor(PciId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PciId").unmarshallLocationName("pciId").build()}).build();
    private static final SdkField<FpgaImageState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(FpgaImage.getter(FpgaImage::state)).setter(FpgaImage.setter(Builder::state)).constructor(FpgaImageState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(FpgaImage.getter(FpgaImage::createTime)).setter(FpgaImage.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").unmarshallLocationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(FpgaImage.getter(FpgaImage::updateTime)).setter(FpgaImage.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").unmarshallLocationName("updateTime").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FpgaImage.getter(FpgaImage::ownerId)).setter(FpgaImage.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> OWNER_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FpgaImage.getter(FpgaImage::ownerAlias)).setter(FpgaImage.setter(Builder::ownerAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAlias").unmarshallLocationName("ownerAlias").build()}).build();
    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(FpgaImage.getter(FpgaImage::productCodes)).setter(FpgaImage.setter(Builder::productCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes").unmarshallLocationName("productCodes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(FpgaImage.getter(FpgaImage::tags)).setter(FpgaImage.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").unmarshallLocationName("tags").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DATA_RETENTION_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(FpgaImage.getter(FpgaImage::dataRetentionSupport)).setter(FpgaImage.setter(Builder::dataRetentionSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRetentionSupport").unmarshallLocationName("dataRetentionSupport").build()}).build();
    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(FpgaImage.getter(FpgaImage::isPublic)).setter(FpgaImage.setter(Builder::isPublic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Public").unmarshallLocationName("public").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPGA_IMAGE_ID_FIELD, FPGA_IMAGE_GLOBAL_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, SHELL_VERSION_FIELD, PCI_ID_FIELD, STATE_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, OWNER_ID_FIELD, OWNER_ALIAS_FIELD, PRODUCT_CODES_FIELD, TAGS_FIELD, DATA_RETENTION_SUPPORT_FIELD, IS_PUBLIC_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fpgaImageId;
    private final String fpgaImageGlobalId;
    private final String name;
    private final String description;
    private final String shellVersion;
    private final PciId pciId;
    private final FpgaImageState state;
    private final Instant createTime;
    private final Instant updateTime;
    private final String ownerId;
    private final String ownerAlias;
    private final List<ProductCode> productCodes;
    private final List<Tag> tags;
    private final Boolean dataRetentionSupport;
    private final Boolean isPublic;

    private FpgaImage(BuilderImpl builder) {
        this.fpgaImageId = builder.fpgaImageId;
        this.fpgaImageGlobalId = builder.fpgaImageGlobalId;
        this.name = builder.name;
        this.description = builder.description;
        this.shellVersion = builder.shellVersion;
        this.pciId = builder.pciId;
        this.state = builder.state;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.ownerId = builder.ownerId;
        this.ownerAlias = builder.ownerAlias;
        this.productCodes = builder.productCodes;
        this.tags = builder.tags;
        this.dataRetentionSupport = builder.dataRetentionSupport;
        this.isPublic = builder.isPublic;
    }

    public String fpgaImageId() {
        return this.fpgaImageId;
    }

    public String fpgaImageGlobalId() {
        return this.fpgaImageGlobalId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String shellVersion() {
        return this.shellVersion;
    }

    public PciId pciId() {
        return this.pciId;
    }

    public FpgaImageState state() {
        return this.state;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Instant updateTime() {
        return this.updateTime;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String ownerAlias() {
        return this.ownerAlias;
    }

    public boolean hasProductCodes() {
        return this.productCodes != null && !(this.productCodes instanceof SdkAutoConstructList);
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Boolean dataRetentionSupport() {
        return this.dataRetentionSupport;
    }

    public Boolean isPublic() {
        return this.isPublic;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fpgaImageGlobalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.shellVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.pciId());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRetentionSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPublic());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FpgaImage)) {
            return false;
        }
        FpgaImage other = (FpgaImage)obj;
        return Objects.equals(this.fpgaImageId(), other.fpgaImageId()) && Objects.equals(this.fpgaImageGlobalId(), other.fpgaImageGlobalId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.shellVersion(), other.shellVersion()) && Objects.equals(this.pciId(), other.pciId()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.ownerAlias(), other.ownerAlias()) && Objects.equals(this.productCodes(), other.productCodes()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.dataRetentionSupport(), other.dataRetentionSupport()) && Objects.equals(this.isPublic(), other.isPublic());
    }

    public String toString() {
        return ToString.builder((String)"FpgaImage").add("FpgaImageId", (Object)this.fpgaImageId()).add("FpgaImageGlobalId", (Object)this.fpgaImageGlobalId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ShellVersion", (Object)this.shellVersion()).add("PciId", (Object)this.pciId()).add("State", (Object)this.state()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("OwnerId", (Object)this.ownerId()).add("OwnerAlias", (Object)this.ownerAlias()).add("ProductCodes", this.productCodes()).add("Tags", this.tags()).add("DataRetentionSupport", (Object)this.dataRetentionSupport()).add("IsPublic", (Object)this.isPublic()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FpgaImageId": {
                return Optional.ofNullable(clazz.cast(this.fpgaImageId()));
            }
            case "FpgaImageGlobalId": {
                return Optional.ofNullable(clazz.cast(this.fpgaImageGlobalId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ShellVersion": {
                return Optional.ofNullable(clazz.cast(this.shellVersion()));
            }
            case "PciId": {
                return Optional.ofNullable(clazz.cast(this.pciId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "OwnerAlias": {
                return Optional.ofNullable(clazz.cast(this.ownerAlias()));
            }
            case "ProductCodes": {
                return Optional.ofNullable(clazz.cast(this.productCodes()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DataRetentionSupport": {
                return Optional.ofNullable(clazz.cast(this.dataRetentionSupport()));
            }
            case "isPublic": {
                return Optional.ofNullable(clazz.cast(this.isPublic()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FpgaImage, T> g) {
        return obj -> g.apply((FpgaImage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fpgaImageId;
        private String fpgaImageGlobalId;
        private String name;
        private String description;
        private String shellVersion;
        private PciId pciId;
        private FpgaImageState state;
        private Instant createTime;
        private Instant updateTime;
        private String ownerId;
        private String ownerAlias;
        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean dataRetentionSupport;
        private Boolean isPublic;

        private BuilderImpl() {
        }

        private BuilderImpl(FpgaImage model) {
            this.fpgaImageId(model.fpgaImageId);
            this.fpgaImageGlobalId(model.fpgaImageGlobalId);
            this.name(model.name);
            this.description(model.description);
            this.shellVersion(model.shellVersion);
            this.pciId(model.pciId);
            this.state(model.state);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.ownerId(model.ownerId);
            this.ownerAlias(model.ownerAlias);
            this.productCodes(model.productCodes);
            this.tags(model.tags);
            this.dataRetentionSupport(model.dataRetentionSupport);
            this.isPublic(model.isPublic);
        }

        public final String getFpgaImageId() {
            return this.fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getFpgaImageGlobalId() {
            return this.fpgaImageGlobalId;
        }

        @Override
        public final Builder fpgaImageGlobalId(String fpgaImageGlobalId) {
            this.fpgaImageGlobalId = fpgaImageGlobalId;
            return this;
        }

        public final void setFpgaImageGlobalId(String fpgaImageGlobalId) {
            this.fpgaImageGlobalId = fpgaImageGlobalId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getShellVersion() {
            return this.shellVersion;
        }

        @Override
        public final Builder shellVersion(String shellVersion) {
            this.shellVersion = shellVersion;
            return this;
        }

        public final void setShellVersion(String shellVersion) {
            this.shellVersion = shellVersion;
        }

        public final PciId.Builder getPciId() {
            return this.pciId != null ? this.pciId.toBuilder() : null;
        }

        @Override
        public final Builder pciId(PciId pciId) {
            this.pciId = pciId;
            return this;
        }

        public final void setPciId(PciId.BuilderImpl pciId) {
            this.pciId = pciId != null ? pciId.build() : null;
        }

        public final FpgaImageState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        @Override
        public final Builder state(FpgaImageState state) {
            this.state = state;
            return this;
        }

        public final void setState(FpgaImageState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getOwnerAlias() {
            return this.ownerAlias;
        }

        @Override
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return this.productCodes != null ? (Collection)this.productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder> ... productCodes) {
            this.productCodes(Stream.of(productCodes).map(c -> (ProductCode)((ProductCode.Builder)ProductCode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getDataRetentionSupport() {
            return this.dataRetentionSupport;
        }

        @Override
        public final Builder dataRetentionSupport(Boolean dataRetentionSupport) {
            this.dataRetentionSupport = dataRetentionSupport;
            return this;
        }

        public final void setDataRetentionSupport(Boolean dataRetentionSupport) {
            this.dataRetentionSupport = dataRetentionSupport;
        }

        public final Boolean getIsPublic() {
            return this.isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        public FpgaImage build() {
            return new FpgaImage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FpgaImage> {
        public Builder fpgaImageId(String var1);

        public Builder fpgaImageGlobalId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder shellVersion(String var1);

        public Builder pciId(PciId var1);

        default public Builder pciId(Consumer<PciId.Builder> pciId) {
            return this.pciId((PciId)((PciId.Builder)PciId.builder().applyMutation(pciId)).build());
        }

        public Builder state(FpgaImageState var1);

        default public Builder state(Consumer<FpgaImageState.Builder> state) {
            return this.state((FpgaImageState)((FpgaImageState.Builder)FpgaImageState.builder().applyMutation(state)).build());
        }

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder ownerId(String var1);

        public Builder ownerAlias(String var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder productCodes(Consumer<ProductCode.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder dataRetentionSupport(Boolean var1);

        public Builder isPublic(Boolean var1);
    }
}

