/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplatePlacementRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplatePlacementRequest> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchTemplatePlacementRequest.getter(LaunchTemplatePlacementRequest::availabilityZone)).setter(LaunchTemplatePlacementRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> AFFINITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchTemplatePlacementRequest.getter(LaunchTemplatePlacementRequest::affinity)).setter(LaunchTemplatePlacementRequest.setter(Builder::affinity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Affinity").unmarshallLocationName("Affinity").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchTemplatePlacementRequest.getter(LaunchTemplatePlacementRequest::groupName)).setter(LaunchTemplatePlacementRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("GroupName").build()}).build();
    private static final SdkField<String> HOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchTemplatePlacementRequest.getter(LaunchTemplatePlacementRequest::hostId)).setter(LaunchTemplatePlacementRequest.setter(Builder::hostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId").unmarshallLocationName("HostId").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchTemplatePlacementRequest.getter(LaunchTemplatePlacementRequest::tenancyAsString)).setter(LaunchTemplatePlacementRequest.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").unmarshallLocationName("Tenancy").build()}).build();
    private static final SdkField<String> SPREAD_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchTemplatePlacementRequest.getter(LaunchTemplatePlacementRequest::spreadDomain)).setter(LaunchTemplatePlacementRequest.setter(Builder::spreadDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpreadDomain").unmarshallLocationName("SpreadDomain").build()}).build();
    private static final SdkField<String> HOST_RESOURCE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchTemplatePlacementRequest.getter(LaunchTemplatePlacementRequest::hostResourceGroupArn)).setter(LaunchTemplatePlacementRequest.setter(Builder::hostResourceGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostResourceGroupArn").unmarshallLocationName("HostResourceGroupArn").build()}).build();
    private static final SdkField<Integer> PARTITION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(LaunchTemplatePlacementRequest.getter(LaunchTemplatePlacementRequest::partitionNumber)).setter(LaunchTemplatePlacementRequest.setter(Builder::partitionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionNumber").unmarshallLocationName("PartitionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, AFFINITY_FIELD, GROUP_NAME_FIELD, HOST_ID_FIELD, TENANCY_FIELD, SPREAD_DOMAIN_FIELD, HOST_RESOURCE_GROUP_ARN_FIELD, PARTITION_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final String affinity;
    private final String groupName;
    private final String hostId;
    private final String tenancy;
    private final String spreadDomain;
    private final String hostResourceGroupArn;
    private final Integer partitionNumber;

    private LaunchTemplatePlacementRequest(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.affinity = builder.affinity;
        this.groupName = builder.groupName;
        this.hostId = builder.hostId;
        this.tenancy = builder.tenancy;
        this.spreadDomain = builder.spreadDomain;
        this.hostResourceGroupArn = builder.hostResourceGroupArn;
        this.partitionNumber = builder.partitionNumber;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String affinity() {
        return this.affinity;
    }

    public String groupName() {
        return this.groupName;
    }

    public String hostId() {
        return this.hostId;
    }

    public Tenancy tenancy() {
        return Tenancy.fromValue(this.tenancy);
    }

    public String tenancyAsString() {
        return this.tenancy;
    }

    public String spreadDomain() {
        return this.spreadDomain;
    }

    public String hostResourceGroupArn() {
        return this.hostResourceGroupArn;
    }

    public Integer partitionNumber() {
        return this.partitionNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.affinity());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spreadDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostResourceGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplatePlacementRequest)) {
            return false;
        }
        LaunchTemplatePlacementRequest other = (LaunchTemplatePlacementRequest)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.affinity(), other.affinity()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.hostId(), other.hostId()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && Objects.equals(this.spreadDomain(), other.spreadDomain()) && Objects.equals(this.hostResourceGroupArn(), other.hostResourceGroupArn()) && Objects.equals(this.partitionNumber(), other.partitionNumber());
    }

    public String toString() {
        return ToString.builder((String)"LaunchTemplatePlacementRequest").add("AvailabilityZone", (Object)this.availabilityZone()).add("Affinity", (Object)this.affinity()).add("GroupName", (Object)this.groupName()).add("HostId", (Object)this.hostId()).add("Tenancy", (Object)this.tenancyAsString()).add("SpreadDomain", (Object)this.spreadDomain()).add("HostResourceGroupArn", (Object)this.hostResourceGroupArn()).add("PartitionNumber", (Object)this.partitionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Affinity": {
                return Optional.ofNullable(clazz.cast(this.affinity()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "HostId": {
                return Optional.ofNullable(clazz.cast(this.hostId()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "SpreadDomain": {
                return Optional.ofNullable(clazz.cast(this.spreadDomain()));
            }
            case "HostResourceGroupArn": {
                return Optional.ofNullable(clazz.cast(this.hostResourceGroupArn()));
            }
            case "PartitionNumber": {
                return Optional.ofNullable(clazz.cast(this.partitionNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplatePlacementRequest, T> g) {
        return obj -> g.apply((LaunchTemplatePlacementRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String affinity;
        private String groupName;
        private String hostId;
        private String tenancy;
        private String spreadDomain;
        private String hostResourceGroupArn;
        private Integer partitionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplatePlacementRequest model) {
            this.availabilityZone(model.availabilityZone);
            this.affinity(model.affinity);
            this.groupName(model.groupName);
            this.hostId(model.hostId);
            this.tenancy(model.tenancy);
            this.spreadDomain(model.spreadDomain);
            this.hostResourceGroupArn(model.hostResourceGroupArn);
            this.partitionNumber(model.partitionNumber);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getAffinity() {
            return this.affinity;
        }

        @Override
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getHostId() {
            return this.hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public final String getTenancyAsString() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final String getSpreadDomain() {
            return this.spreadDomain;
        }

        @Override
        public final Builder spreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
            return this;
        }

        public final void setSpreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
        }

        public final String getHostResourceGroupArn() {
            return this.hostResourceGroupArn;
        }

        @Override
        public final Builder hostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
            return this;
        }

        public final void setHostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
        }

        public final Integer getPartitionNumber() {
            return this.partitionNumber;
        }

        @Override
        public final Builder partitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
            return this;
        }

        public final void setPartitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
        }

        public LaunchTemplatePlacementRequest build() {
            return new LaunchTemplatePlacementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplatePlacementRequest> {
        public Builder availabilityZone(String var1);

        public Builder affinity(String var1);

        public Builder groupName(String var1);

        public Builder hostId(String var1);

        public Builder tenancy(String var1);

        public Builder tenancy(Tenancy var1);

        public Builder spreadDomain(String var1);

        public Builder hostResourceGroupArn(String var1);

        public Builder partitionNumber(Integer var1);
    }
}

