/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the transit gateway peering attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayPeeringAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayPeeringAttachment.Builder, TransitGatewayPeeringAttachment> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayPeeringAttachment::transitGatewayAttachmentId))
            .setter(setter(Builder::transitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId")
                    .unmarshallLocationName("transitGatewayAttachmentId").build()).build();

    private static final SdkField<PeeringTgwInfo> REQUESTER_TGW_INFO_FIELD = SdkField
            .<PeeringTgwInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(TransitGatewayPeeringAttachment::requesterTgwInfo))
            .setter(setter(Builder::requesterTgwInfo))
            .constructor(PeeringTgwInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterTgwInfo")
                    .unmarshallLocationName("requesterTgwInfo").build()).build();

    private static final SdkField<PeeringTgwInfo> ACCEPTER_TGW_INFO_FIELD = SdkField
            .<PeeringTgwInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(TransitGatewayPeeringAttachment::accepterTgwInfo))
            .setter(setter(Builder::accepterTgwInfo))
            .constructor(PeeringTgwInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccepterTgwInfo")
                    .unmarshallLocationName("accepterTgwInfo").build()).build();

    private static final SdkField<PeeringAttachmentStatus> STATUS_FIELD = SdkField
            .<PeeringAttachmentStatus> builder(MarshallingType.SDK_POJO)
            .getter(getter(TransitGatewayPeeringAttachment::status))
            .setter(setter(Builder::status))
            .constructor(PeeringAttachmentStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayPeeringAttachment::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TransitGatewayPeeringAttachment::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("creationTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(TransitGatewayPeeringAttachment::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, REQUESTER_TGW_INFO_FIELD, ACCEPTER_TGW_INFO_FIELD, STATUS_FIELD, STATE_FIELD,
            CREATION_TIME_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitGatewayAttachmentId;

    private final PeeringTgwInfo requesterTgwInfo;

    private final PeeringTgwInfo accepterTgwInfo;

    private final PeeringAttachmentStatus status;

    private final String state;

    private final Instant creationTime;

    private final List<Tag> tags;

    private TransitGatewayPeeringAttachment(BuilderImpl builder) {
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.requesterTgwInfo = builder.requesterTgwInfo;
        this.accepterTgwInfo = builder.accepterTgwInfo;
        this.status = builder.status;
        this.state = builder.state;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the transit gateway peering attachment.
     * </p>
     * 
     * @return The ID of the transit gateway peering attachment.
     */
    public String transitGatewayAttachmentId() {
        return transitGatewayAttachmentId;
    }

    /**
     * <p>
     * Information about the requester transit gateway.
     * </p>
     * 
     * @return Information about the requester transit gateway.
     */
    public PeeringTgwInfo requesterTgwInfo() {
        return requesterTgwInfo;
    }

    /**
     * <p>
     * Information about the accepter transit gateway.
     * </p>
     * 
     * @return Information about the accepter transit gateway.
     */
    public PeeringTgwInfo accepterTgwInfo() {
        return accepterTgwInfo;
    }

    /**
     * <p>
     * The status of the transit gateway peering attachment.
     * </p>
     * 
     * @return The status of the transit gateway peering attachment.
     */
    public PeeringAttachmentStatus status() {
        return status;
    }

    /**
     * <p>
     * The state of the transit gateway peering attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayAttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the transit gateway peering attachment.
     * @see TransitGatewayAttachmentState
     */
    public TransitGatewayAttachmentState state() {
        return TransitGatewayAttachmentState.fromValue(state);
    }

    /**
     * <p>
     * The state of the transit gateway peering attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayAttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the transit gateway peering attachment.
     * @see TransitGatewayAttachmentState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The time the transit gateway peering attachment was created.
     * </p>
     * 
     * @return The time the transit gateway peering attachment was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the transit gateway peering attachment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags for the transit gateway peering attachment.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(requesterTgwInfo());
        hashCode = 31 * hashCode + Objects.hashCode(accepterTgwInfo());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayPeeringAttachment)) {
            return false;
        }
        TransitGatewayPeeringAttachment other = (TransitGatewayPeeringAttachment) obj;
        return Objects.equals(transitGatewayAttachmentId(), other.transitGatewayAttachmentId())
                && Objects.equals(requesterTgwInfo(), other.requesterTgwInfo())
                && Objects.equals(accepterTgwInfo(), other.accepterTgwInfo()) && Objects.equals(status(), other.status())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransitGatewayPeeringAttachment")
                .add("TransitGatewayAttachmentId", transitGatewayAttachmentId()).add("RequesterTgwInfo", requesterTgwInfo())
                .add("AccepterTgwInfo", accepterTgwInfo()).add("Status", status()).add("State", stateAsString())
                .add("CreationTime", creationTime()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentId()));
        case "RequesterTgwInfo":
            return Optional.ofNullable(clazz.cast(requesterTgwInfo()));
        case "AccepterTgwInfo":
            return Optional.ofNullable(clazz.cast(accepterTgwInfo()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayPeeringAttachment, T> g) {
        return obj -> g.apply((TransitGatewayPeeringAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayPeeringAttachment> {
        /**
         * <p>
         * The ID of the transit gateway peering attachment.
         * </p>
         * 
         * @param transitGatewayAttachmentId
         *        The ID of the transit gateway peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentId(String transitGatewayAttachmentId);

        /**
         * <p>
         * Information about the requester transit gateway.
         * </p>
         * 
         * @param requesterTgwInfo
         *        Information about the requester transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterTgwInfo(PeeringTgwInfo requesterTgwInfo);

        /**
         * <p>
         * Information about the requester transit gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link PeeringTgwInfo.Builder} avoiding the need to
         * create one manually via {@link PeeringTgwInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link PeeringTgwInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #requesterTgwInfo(PeeringTgwInfo)}.
         * 
         * @param requesterTgwInfo
         *        a consumer that will call methods on {@link PeeringTgwInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requesterTgwInfo(PeeringTgwInfo)
         */
        default Builder requesterTgwInfo(Consumer<PeeringTgwInfo.Builder> requesterTgwInfo) {
            return requesterTgwInfo(PeeringTgwInfo.builder().applyMutation(requesterTgwInfo).build());
        }

        /**
         * <p>
         * Information about the accepter transit gateway.
         * </p>
         * 
         * @param accepterTgwInfo
         *        Information about the accepter transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepterTgwInfo(PeeringTgwInfo accepterTgwInfo);

        /**
         * <p>
         * Information about the accepter transit gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link PeeringTgwInfo.Builder} avoiding the need to
         * create one manually via {@link PeeringTgwInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link PeeringTgwInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #accepterTgwInfo(PeeringTgwInfo)}.
         * 
         * @param accepterTgwInfo
         *        a consumer that will call methods on {@link PeeringTgwInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accepterTgwInfo(PeeringTgwInfo)
         */
        default Builder accepterTgwInfo(Consumer<PeeringTgwInfo.Builder> accepterTgwInfo) {
            return accepterTgwInfo(PeeringTgwInfo.builder().applyMutation(accepterTgwInfo).build());
        }

        /**
         * <p>
         * The status of the transit gateway peering attachment.
         * </p>
         * 
         * @param status
         *        The status of the transit gateway peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(PeeringAttachmentStatus status);

        /**
         * <p>
         * The status of the transit gateway peering attachment.
         * </p>
         * This is a convenience that creates an instance of the {@link PeeringAttachmentStatus.Builder} avoiding the
         * need to create one manually via {@link PeeringAttachmentStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link PeeringAttachmentStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #status(PeeringAttachmentStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link PeeringAttachmentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(PeeringAttachmentStatus)
         */
        default Builder status(Consumer<PeeringAttachmentStatus.Builder> status) {
            return status(PeeringAttachmentStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The state of the transit gateway peering attachment.
         * </p>
         * 
         * @param state
         *        The state of the transit gateway peering attachment.
         * @see TransitGatewayAttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the transit gateway peering attachment.
         * </p>
         * 
         * @param state
         *        The state of the transit gateway peering attachment.
         * @see TransitGatewayAttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentState
         */
        Builder state(TransitGatewayAttachmentState state);

        /**
         * <p>
         * The time the transit gateway peering attachment was created.
         * </p>
         * 
         * @param creationTime
         *        The time the transit gateway peering attachment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The tags for the transit gateway peering attachment.
         * </p>
         * 
         * @param tags
         *        The tags for the transit gateway peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the transit gateway peering attachment.
         * </p>
         * 
         * @param tags
         *        The tags for the transit gateway peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the transit gateway peering attachment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayAttachmentId;

        private PeeringTgwInfo requesterTgwInfo;

        private PeeringTgwInfo accepterTgwInfo;

        private PeeringAttachmentStatus status;

        private String state;

        private Instant creationTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayPeeringAttachment model) {
            transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            requesterTgwInfo(model.requesterTgwInfo);
            accepterTgwInfo(model.accepterTgwInfo);
            status(model.status);
            state(model.state);
            creationTime(model.creationTime);
            tags(model.tags);
        }

        public final String getTransitGatewayAttachmentId() {
            return transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        public final PeeringTgwInfo.Builder getRequesterTgwInfo() {
            return requesterTgwInfo != null ? requesterTgwInfo.toBuilder() : null;
        }

        @Override
        public final Builder requesterTgwInfo(PeeringTgwInfo requesterTgwInfo) {
            this.requesterTgwInfo = requesterTgwInfo;
            return this;
        }

        public final void setRequesterTgwInfo(PeeringTgwInfo.BuilderImpl requesterTgwInfo) {
            this.requesterTgwInfo = requesterTgwInfo != null ? requesterTgwInfo.build() : null;
        }

        public final PeeringTgwInfo.Builder getAccepterTgwInfo() {
            return accepterTgwInfo != null ? accepterTgwInfo.toBuilder() : null;
        }

        @Override
        public final Builder accepterTgwInfo(PeeringTgwInfo accepterTgwInfo) {
            this.accepterTgwInfo = accepterTgwInfo;
            return this;
        }

        public final void setAccepterTgwInfo(PeeringTgwInfo.BuilderImpl accepterTgwInfo) {
            this.accepterTgwInfo = accepterTgwInfo != null ? accepterTgwInfo.build() : null;
        }

        public final PeeringAttachmentStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(PeeringAttachmentStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(PeeringAttachmentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayAttachmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public TransitGatewayPeeringAttachment build() {
            return new TransitGatewayPeeringAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
