/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Spot Instance state change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpotInstanceStateFault implements SdkPojo, Serializable,
        ToCopyableBuilder<SpotInstanceStateFault.Builder, SpotInstanceStateFault> {
    private static final SdkField<String> CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SpotInstanceStateFault::code))
            .setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code")
                    .unmarshallLocationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SpotInstanceStateFault::message))
            .setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message")
                    .unmarshallLocationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String message;

    private SpotInstanceStateFault(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The reason code for the Spot Instance state change.
     * </p>
     * 
     * @return The reason code for the Spot Instance state change.
     */
    public String code() {
        return code;
    }

    /**
     * <p>
     * The message for the Spot Instance state change.
     * </p>
     * 
     * @return The message for the Spot Instance state change.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotInstanceStateFault)) {
            return false;
        }
        SpotInstanceStateFault other = (SpotInstanceStateFault) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SpotInstanceStateFault").add("Code", code()).add("Message", message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotInstanceStateFault, T> g) {
        return obj -> g.apply((SpotInstanceStateFault) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpotInstanceStateFault> {
        /**
         * <p>
         * The reason code for the Spot Instance state change.
         * </p>
         * 
         * @param code
         *        The reason code for the Spot Instance state change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The message for the Spot Instance state change.
         * </p>
         * 
         * @param message
         *        The message for the Spot Instance state change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotInstanceStateFault model) {
            code(model.code);
            message(model.message);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public SpotInstanceStateFault build() {
            return new SpotInstanceStateFault(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
