/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of PurchaseScheduledInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseScheduledInstancesResponse extends Ec2Response implements
        ToCopyableBuilder<PurchaseScheduledInstancesResponse.Builder, PurchaseScheduledInstancesResponse> {
    private static final SdkField<List<ScheduledInstance>> SCHEDULED_INSTANCE_SET_FIELD = SdkField
            .<List<ScheduledInstance>> builder(MarshallingType.LIST)
            .getter(getter(PurchaseScheduledInstancesResponse::scheduledInstanceSet))
            .setter(setter(Builder::scheduledInstanceSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledInstanceSet")
                    .unmarshallLocationName("scheduledInstanceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ScheduledInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_INSTANCE_SET_FIELD));

    private final List<ScheduledInstance> scheduledInstanceSet;

    private PurchaseScheduledInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledInstanceSet = builder.scheduledInstanceSet;
    }

    /**
     * Returns true if the ScheduledInstanceSet property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasScheduledInstanceSet() {
        return scheduledInstanceSet != null && !(scheduledInstanceSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Scheduled Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasScheduledInstanceSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the Scheduled Instances.
     */
    public List<ScheduledInstance> scheduledInstanceSet() {
        return scheduledInstanceSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduledInstanceSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseScheduledInstancesResponse)) {
            return false;
        }
        PurchaseScheduledInstancesResponse other = (PurchaseScheduledInstancesResponse) obj;
        return Objects.equals(scheduledInstanceSet(), other.scheduledInstanceSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PurchaseScheduledInstancesResponse").add("ScheduledInstanceSet", scheduledInstanceSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledInstanceSet":
            return Optional.ofNullable(clazz.cast(scheduledInstanceSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseScheduledInstancesResponse, T> g) {
        return obj -> g.apply((PurchaseScheduledInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, PurchaseScheduledInstancesResponse> {
        /**
         * <p>
         * Information about the Scheduled Instances.
         * </p>
         * 
         * @param scheduledInstanceSet
         *        Information about the Scheduled Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledInstanceSet(Collection<ScheduledInstance> scheduledInstanceSet);

        /**
         * <p>
         * Information about the Scheduled Instances.
         * </p>
         * 
         * @param scheduledInstanceSet
         *        Information about the Scheduled Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledInstanceSet(ScheduledInstance... scheduledInstanceSet);

        /**
         * <p>
         * Information about the Scheduled Instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScheduledInstance>.Builder} avoiding the
         * need to create one manually via {@link List<ScheduledInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScheduledInstance>.Builder#build()} is called immediately
         * and its result is passed to {@link #scheduledInstanceSet(List<ScheduledInstance>)}.
         * 
         * @param scheduledInstanceSet
         *        a consumer that will call methods on {@link List<ScheduledInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledInstanceSet(List<ScheduledInstance>)
         */
        Builder scheduledInstanceSet(Consumer<ScheduledInstance.Builder>... scheduledInstanceSet);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ScheduledInstance> scheduledInstanceSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseScheduledInstancesResponse model) {
            super(model);
            scheduledInstanceSet(model.scheduledInstanceSet);
        }

        public final Collection<ScheduledInstance.Builder> getScheduledInstanceSet() {
            return scheduledInstanceSet != null ? scheduledInstanceSet.stream().map(ScheduledInstance::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledInstanceSet(Collection<ScheduledInstance> scheduledInstanceSet) {
            this.scheduledInstanceSet = PurchasedScheduledInstanceSetCopier.copy(scheduledInstanceSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceSet(ScheduledInstance... scheduledInstanceSet) {
            scheduledInstanceSet(Arrays.asList(scheduledInstanceSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceSet(Consumer<ScheduledInstance.Builder>... scheduledInstanceSet) {
            scheduledInstanceSet(Stream.of(scheduledInstanceSet).map(c -> ScheduledInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setScheduledInstanceSet(Collection<ScheduledInstance.BuilderImpl> scheduledInstanceSet) {
            this.scheduledInstanceSet = PurchasedScheduledInstanceSetCopier.copyFromBuilder(scheduledInstanceSet);
        }

        @Override
        public PurchaseScheduledInstancesResponse build() {
            return new PurchaseScheduledInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
