/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseHostReservationRequest extends Ec2Request implements
        ToCopyableBuilder<PurchaseHostReservationRequest.Builder, PurchaseHostReservationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PurchaseHostReservationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PurchaseHostReservationRequest::currencyCodeAsString))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode")
                    .unmarshallLocationName("CurrencyCode").build()).build();

    private static final SdkField<List<String>> HOST_ID_SET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PurchaseHostReservationRequest::hostIdSet))
            .setter(setter(Builder::hostIdSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostIdSet")
                    .unmarshallLocationName("HostIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> LIMIT_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PurchaseHostReservationRequest::limitPrice))
            .setter(setter(Builder::limitPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitPrice")
                    .unmarshallLocationName("LimitPrice").build()).build();

    private static final SdkField<String> OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PurchaseHostReservationRequest::offeringId))
            .setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingId")
                    .unmarshallLocationName("OfferingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CURRENCY_CODE_FIELD, HOST_ID_SET_FIELD, LIMIT_PRICE_FIELD, OFFERING_ID_FIELD));

    private final String clientToken;

    private final String currencyCode;

    private final List<String> hostIdSet;

    private final String limitPrice;

    private final String offeringId;

    private PurchaseHostReservationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.currencyCode = builder.currencyCode;
        this.hostIdSet = builder.hostIdSet;
        this.limitPrice = builder.limitPrice;
        this.offeringId = builder.offeringId;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
     * <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
     * <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
     *         <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
     *         <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
     * <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
     * <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
     *         <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
     *         <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCodeAsString() {
        return currencyCode;
    }

    /**
     * Returns true if the HostIdSet property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasHostIdSet() {
        return hostIdSet != null && !(hostIdSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Dedicated Hosts with which the reservation will be associated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHostIdSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the Dedicated Hosts with which the reservation will be associated.
     */
    public List<String> hostIdSet() {
        return hostIdSet;
    }

    /**
     * <p>
     * The specified limit is checked against the total upfront cost of the reservation (calculated as the offering's
     * upfront cost multiplied by the host count). If the total upfront cost is greater than the specified price limit,
     * the request fails. This is used to ensure that the purchase does not exceed the expected upfront cost of the
     * purchase. At this time, the only supported currency is <code>USD</code>. For example, to indicate a limit price
     * of USD 100, specify 100.00.
     * </p>
     * 
     * @return The specified limit is checked against the total upfront cost of the reservation (calculated as the
     *         offering's upfront cost multiplied by the host count). If the total upfront cost is greater than the
     *         specified price limit, the request fails. This is used to ensure that the purchase does not exceed the
     *         expected upfront cost of the purchase. At this time, the only supported currency is <code>USD</code>. For
     *         example, to indicate a limit price of USD 100, specify 100.00.
     */
    public String limitPrice() {
        return limitPrice;
    }

    /**
     * <p>
     * The ID of the offering.
     * </p>
     * 
     * @return The ID of the offering.
     */
    public String offeringId() {
        return offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostIdSet());
        hashCode = 31 * hashCode + Objects.hashCode(limitPrice());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseHostReservationRequest)) {
            return false;
        }
        PurchaseHostReservationRequest other = (PurchaseHostReservationRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(currencyCodeAsString(), other.currencyCodeAsString())
                && Objects.equals(hostIdSet(), other.hostIdSet()) && Objects.equals(limitPrice(), other.limitPrice())
                && Objects.equals(offeringId(), other.offeringId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PurchaseHostReservationRequest").add("ClientToken", clientToken())
                .add("CurrencyCode", currencyCodeAsString()).add("HostIdSet", hostIdSet()).add("LimitPrice", limitPrice())
                .add("OfferingId", offeringId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCodeAsString()));
        case "HostIdSet":
            return Optional.ofNullable(clazz.cast(hostIdSet()));
        case "LimitPrice":
            return Optional.ofNullable(clazz.cast(limitPrice()));
        case "OfferingId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseHostReservationRequest, T> g) {
        return obj -> g.apply((PurchaseHostReservationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, PurchaseHostReservationRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to
         *        Ensure Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
         * <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
         * <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
         *        <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
         *        <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
         * <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
         * <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and
         *        <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is
         *        <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The IDs of the Dedicated Hosts with which the reservation will be associated.
         * </p>
         * 
         * @param hostIdSet
         *        The IDs of the Dedicated Hosts with which the reservation will be associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(Collection<String> hostIdSet);

        /**
         * <p>
         * The IDs of the Dedicated Hosts with which the reservation will be associated.
         * </p>
         * 
         * @param hostIdSet
         *        The IDs of the Dedicated Hosts with which the reservation will be associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(String... hostIdSet);

        /**
         * <p>
         * The specified limit is checked against the total upfront cost of the reservation (calculated as the
         * offering's upfront cost multiplied by the host count). If the total upfront cost is greater than the
         * specified price limit, the request fails. This is used to ensure that the purchase does not exceed the
         * expected upfront cost of the purchase. At this time, the only supported currency is <code>USD</code>. For
         * example, to indicate a limit price of USD 100, specify 100.00.
         * </p>
         * 
         * @param limitPrice
         *        The specified limit is checked against the total upfront cost of the reservation (calculated as the
         *        offering's upfront cost multiplied by the host count). If the total upfront cost is greater than the
         *        specified price limit, the request fails. This is used to ensure that the purchase does not exceed the
         *        expected upfront cost of the purchase. At this time, the only supported currency is <code>USD</code>.
         *        For example, to indicate a limit price of USD 100, specify 100.00.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitPrice(String limitPrice);

        /**
         * <p>
         * The ID of the offering.
         * </p>
         * 
         * @param offeringId
         *        The ID of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientToken;

        private String currencyCode;

        private List<String> hostIdSet = DefaultSdkAutoConstructList.getInstance();

        private String limitPrice;

        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseHostReservationRequest model) {
            super(model);
            clientToken(model.clientToken);
            currencyCode(model.currencyCode);
            hostIdSet(model.hostIdSet);
            limitPrice(model.limitPrice);
            offeringId(model.offeringId);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getCurrencyCodeAsString() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Collection<String> getHostIdSet() {
            return hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String... hostIdSet) {
            hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
        }

        public final String getLimitPrice() {
            return limitPrice;
        }

        @Override
        public final Builder limitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
            return this;
        }

        public final void setLimitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseHostReservationRequest build() {
            return new PurchaseHostReservationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
