/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the placement of an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Placement implements SdkPojo, Serializable, ToCopyableBuilder<Placement.Builder, Placement> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Placement::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> AFFINITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Placement::affinity))
            .setter(setter(Builder::affinity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Affinity")
                    .unmarshallLocationName("affinity").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Placement::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("groupName").build()).build();

    private static final SdkField<Integer> PARTITION_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Placement::partitionNumber))
            .setter(setter(Builder::partitionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionNumber")
                    .unmarshallLocationName("partitionNumber").build()).build();

    private static final SdkField<String> HOST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Placement::hostId))
            .setter(setter(Builder::hostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId")
                    .unmarshallLocationName("hostId").build()).build();

    private static final SdkField<String> TENANCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Placement::tenancyAsString))
            .setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy")
                    .unmarshallLocationName("tenancy").build()).build();

    private static final SdkField<String> SPREAD_DOMAIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Placement::spreadDomain))
            .setter(setter(Builder::spreadDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpreadDomain")
                    .unmarshallLocationName("spreadDomain").build()).build();

    private static final SdkField<String> HOST_RESOURCE_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Placement::hostResourceGroupArn))
            .setter(setter(Builder::hostResourceGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostResourceGroupArn")
                    .unmarshallLocationName("hostResourceGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            AFFINITY_FIELD, GROUP_NAME_FIELD, PARTITION_NUMBER_FIELD, HOST_ID_FIELD, TENANCY_FIELD, SPREAD_DOMAIN_FIELD,
            HOST_RESOURCE_GROUP_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String affinity;

    private final String groupName;

    private final Integer partitionNumber;

    private final String hostId;

    private final String tenancy;

    private final String spreadDomain;

    private final String hostResourceGroupArn;

    private Placement(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.affinity = builder.affinity;
        this.groupName = builder.groupName;
        this.partitionNumber = builder.partitionNumber;
        this.hostId = builder.hostId;
        this.tenancy = builder.tenancy;
        this.spreadDomain = builder.spreadDomain;
        this.hostResourceGroupArn = builder.hostResourceGroupArn;
    }

    /**
     * <p>
     * The Availability Zone of the instance.
     * </p>
     * <p>
     * If not specified, an Availability Zone will be automatically chosen for you based on the load balancing criteria
     * for the Region.
     * </p>
     * 
     * @return The Availability Zone of the instance.</p>
     *         <p>
     *         If not specified, an Availability Zone will be automatically chosen for you based on the load balancing
     *         criteria for the Region.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the
     * <a>ImportInstance</a> command.
     * </p>
     * 
     * @return The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the
     *         <a>ImportInstance</a> command.
     */
    public String affinity() {
        return affinity;
    }

    /**
     * <p>
     * The name of the placement group the instance is in.
     * </p>
     * 
     * @return The name of the placement group the instance is in.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The number of the partition the instance is in. Valid only if the placement group strategy is set to
     * <code>partition</code>.
     * </p>
     * 
     * @return The number of the partition the instance is in. Valid only if the placement group strategy is set to
     *         <code>partition</code>.
     */
    public Integer partitionNumber() {
        return partitionNumber;
    }

    /**
     * <p>
     * The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the
     * <a>ImportInstance</a> command.
     * </p>
     * 
     * @return The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the
     *         <a>ImportInstance</a> command.
     */
    public String hostId() {
        return hostId;
    }

    /**
     * <p>
     * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the
     * <a>ImportInstance</a> command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     *         <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for
     *         the <a>ImportInstance</a> command.
     * @see Tenancy
     */
    public Tenancy tenancy() {
        return Tenancy.fromValue(tenancy);
    }

    /**
     * <p>
     * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the
     * <a>ImportInstance</a> command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     *         <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for
     *         the <a>ImportInstance</a> command.
     * @see Tenancy
     */
    public String tenancyAsString() {
        return tenancy;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public String spreadDomain() {
        return spreadDomain;
    }

    /**
     * <p>
     * The ARN of the host resource group in which to launch the instances. If you specify a host resource group ARN,
     * omit the <b>Tenancy</b> parameter or set it to <code>host</code>.
     * </p>
     * 
     * @return The ARN of the host resource group in which to launch the instances. If you specify a host resource group
     *         ARN, omit the <b>Tenancy</b> parameter or set it to <code>host</code>.
     */
    public String hostResourceGroupArn() {
        return hostResourceGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(affinity());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(partitionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hostId());
        hashCode = 31 * hashCode + Objects.hashCode(tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spreadDomain());
        hashCode = 31 * hashCode + Objects.hashCode(hostResourceGroupArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Placement)) {
            return false;
        }
        Placement other = (Placement) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(affinity(), other.affinity())
                && Objects.equals(groupName(), other.groupName()) && Objects.equals(partitionNumber(), other.partitionNumber())
                && Objects.equals(hostId(), other.hostId()) && Objects.equals(tenancyAsString(), other.tenancyAsString())
                && Objects.equals(spreadDomain(), other.spreadDomain())
                && Objects.equals(hostResourceGroupArn(), other.hostResourceGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Placement").add("AvailabilityZone", availabilityZone()).add("Affinity", affinity())
                .add("GroupName", groupName()).add("PartitionNumber", partitionNumber()).add("HostId", hostId())
                .add("Tenancy", tenancyAsString()).add("SpreadDomain", spreadDomain())
                .add("HostResourceGroupArn", hostResourceGroupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Affinity":
            return Optional.ofNullable(clazz.cast(affinity()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "PartitionNumber":
            return Optional.ofNullable(clazz.cast(partitionNumber()));
        case "HostId":
            return Optional.ofNullable(clazz.cast(hostId()));
        case "Tenancy":
            return Optional.ofNullable(clazz.cast(tenancyAsString()));
        case "SpreadDomain":
            return Optional.ofNullable(clazz.cast(spreadDomain()));
        case "HostResourceGroupArn":
            return Optional.ofNullable(clazz.cast(hostResourceGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Placement, T> g) {
        return obj -> g.apply((Placement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Placement> {
        /**
         * <p>
         * The Availability Zone of the instance.
         * </p>
         * <p>
         * If not specified, an Availability Zone will be automatically chosen for you based on the load balancing
         * criteria for the Region.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the instance.</p>
         *        <p>
         *        If not specified, an Availability Zone will be automatically chosen for you based on the load
         *        balancing criteria for the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the
         * <a>ImportInstance</a> command.
         * </p>
         * 
         * @param affinity
         *        The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the
         *        <a>ImportInstance</a> command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affinity(String affinity);

        /**
         * <p>
         * The name of the placement group the instance is in.
         * </p>
         * 
         * @param groupName
         *        The name of the placement group the instance is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The number of the partition the instance is in. Valid only if the placement group strategy is set to
         * <code>partition</code>.
         * </p>
         * 
         * @param partitionNumber
         *        The number of the partition the instance is in. Valid only if the placement group strategy is set to
         *        <code>partition</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionNumber(Integer partitionNumber);

        /**
         * <p>
         * The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the
         * <a>ImportInstance</a> command.
         * </p>
         * 
         * @param hostId
         *        The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the
         *        <a>ImportInstance</a> command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostId(String hostId);

        /**
         * <p>
         * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the
         * <a>ImportInstance</a> command.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         *        <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported
         *        for the <a>ImportInstance</a> command.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the
         * <a>ImportInstance</a> command.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         *        <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported
         *        for the <a>ImportInstance</a> command.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(Tenancy tenancy);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param spreadDomain
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spreadDomain(String spreadDomain);

        /**
         * <p>
         * The ARN of the host resource group in which to launch the instances. If you specify a host resource group
         * ARN, omit the <b>Tenancy</b> parameter or set it to <code>host</code>.
         * </p>
         * 
         * @param hostResourceGroupArn
         *        The ARN of the host resource group in which to launch the instances. If you specify a host resource
         *        group ARN, omit the <b>Tenancy</b> parameter or set it to <code>host</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostResourceGroupArn(String hostResourceGroupArn);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String affinity;

        private String groupName;

        private Integer partitionNumber;

        private String hostId;

        private String tenancy;

        private String spreadDomain;

        private String hostResourceGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Placement model) {
            availabilityZone(model.availabilityZone);
            affinity(model.affinity);
            groupName(model.groupName);
            partitionNumber(model.partitionNumber);
            hostId(model.hostId);
            tenancy(model.tenancy);
            spreadDomain(model.spreadDomain);
            hostResourceGroupArn(model.hostResourceGroupArn);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getAffinity() {
            return affinity;
        }

        @Override
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Integer getPartitionNumber() {
            return partitionNumber;
        }

        @Override
        public final Builder partitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
            return this;
        }

        public final void setPartitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
        }

        public final String getHostId() {
            return hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public final String getTenancyAsString() {
            return tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final String getSpreadDomain() {
            return spreadDomain;
        }

        @Override
        public final Builder spreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
            return this;
        }

        public final void setSpreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
        }

        public final String getHostResourceGroupArn() {
            return hostResourceGroupArn;
        }

        @Override
        public final Builder hostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
            return this;
        }

        public final void setHostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
        }

        @Override
        public Placement build() {
            return new Placement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
