/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an association between a local gateway route table and a virtual interface group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocalGatewayRouteTableVirtualInterfaceGroupAssociation
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<LocalGatewayRouteTableVirtualInterfaceGroupAssociation.Builder, LocalGatewayRouteTableVirtualInterfaceGroupAssociation> {
    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_VIRTUAL_INTERFACE_GROUP_ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::localGatewayRouteTableVirtualInterfaceGroupAssociationId))
            .setter(setter(Builder::localGatewayRouteTableVirtualInterfaceGroupAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayRouteTableVirtualInterfaceGroupAssociationId")
                    .unmarshallLocationName("localGatewayRouteTableVirtualInterfaceGroupAssociationId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::localGatewayVirtualInterfaceGroupId))
            .setter(setter(Builder::localGatewayVirtualInterfaceGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayVirtualInterfaceGroupId")
                    .unmarshallLocationName("localGatewayVirtualInterfaceGroupId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::localGatewayId))
            .setter(setter(Builder::localGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId")
                    .unmarshallLocationName("localGatewayId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::localGatewayRouteTableId))
            .setter(setter(Builder::localGatewayRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableId")
                    .unmarshallLocationName("localGatewayRouteTableId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::state))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOCAL_GATEWAY_ROUTE_TABLE_VIRTUAL_INTERFACE_GROUP_ASSOCIATION_ID_FIELD,
            LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD, LOCAL_GATEWAY_ID_FIELD, LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD,
            STATE_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String localGatewayRouteTableVirtualInterfaceGroupAssociationId;

    private final String localGatewayVirtualInterfaceGroupId;

    private final String localGatewayId;

    private final String localGatewayRouteTableId;

    private final String state;

    private final List<Tag> tags;

    private LocalGatewayRouteTableVirtualInterfaceGroupAssociation(BuilderImpl builder) {
        this.localGatewayRouteTableVirtualInterfaceGroupAssociationId = builder.localGatewayRouteTableVirtualInterfaceGroupAssociationId;
        this.localGatewayVirtualInterfaceGroupId = builder.localGatewayVirtualInterfaceGroupId;
        this.localGatewayId = builder.localGatewayId;
        this.localGatewayRouteTableId = builder.localGatewayRouteTableId;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public String localGatewayRouteTableVirtualInterfaceGroupAssociationId() {
        return localGatewayRouteTableVirtualInterfaceGroupAssociationId;
    }

    /**
     * <p>
     * The ID of the virtual interface group.
     * </p>
     * 
     * @return The ID of the virtual interface group.
     */
    public String localGatewayVirtualInterfaceGroupId() {
        return localGatewayVirtualInterfaceGroupId;
    }

    /**
     * <p>
     * The ID of the local gateway.
     * </p>
     * 
     * @return The ID of the local gateway.
     */
    public String localGatewayId() {
        return localGatewayId;
    }

    /**
     * <p>
     * The ID of the local gateway route table.
     * </p>
     * 
     * @return The ID of the local gateway route table.
     */
    public String localGatewayRouteTableId() {
        return localGatewayRouteTableId;
    }

    /**
     * <p>
     * The state of the association.
     * </p>
     * 
     * @return The state of the association.
     */
    public String state() {
        return state;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags assigned to the association.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTableVirtualInterfaceGroupAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayVirtualInterfaceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalGatewayRouteTableVirtualInterfaceGroupAssociation)) {
            return false;
        }
        LocalGatewayRouteTableVirtualInterfaceGroupAssociation other = (LocalGatewayRouteTableVirtualInterfaceGroupAssociation) obj;
        return Objects.equals(localGatewayRouteTableVirtualInterfaceGroupAssociationId(),
                other.localGatewayRouteTableVirtualInterfaceGroupAssociationId())
                && Objects.equals(localGatewayVirtualInterfaceGroupId(), other.localGatewayVirtualInterfaceGroupId())
                && Objects.equals(localGatewayId(), other.localGatewayId())
                && Objects.equals(localGatewayRouteTableId(), other.localGatewayRouteTableId())
                && Objects.equals(state(), other.state()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("LocalGatewayRouteTableVirtualInterfaceGroupAssociation")
                .add("LocalGatewayRouteTableVirtualInterfaceGroupAssociationId",
                        localGatewayRouteTableVirtualInterfaceGroupAssociationId())
                .add("LocalGatewayVirtualInterfaceGroupId", localGatewayVirtualInterfaceGroupId())
                .add("LocalGatewayId", localGatewayId()).add("LocalGatewayRouteTableId", localGatewayRouteTableId())
                .add("State", state()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayRouteTableVirtualInterfaceGroupAssociationId":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableVirtualInterfaceGroupAssociationId()));
        case "LocalGatewayVirtualInterfaceGroupId":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceGroupId()));
        case "LocalGatewayId":
            return Optional.ofNullable(clazz.cast(localGatewayId()));
        case "LocalGatewayRouteTableId":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalGatewayRouteTableVirtualInterfaceGroupAssociation, T> g) {
        return obj -> g.apply((LocalGatewayRouteTableVirtualInterfaceGroupAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocalGatewayRouteTableVirtualInterfaceGroupAssociation> {
        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param localGatewayRouteTableVirtualInterfaceGroupAssociationId
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableVirtualInterfaceGroupAssociationId(
                String localGatewayRouteTableVirtualInterfaceGroupAssociationId);

        /**
         * <p>
         * The ID of the virtual interface group.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceGroupId
         *        The ID of the virtual interface group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId);

        /**
         * <p>
         * The ID of the local gateway.
         * </p>
         * 
         * @param localGatewayId
         *        The ID of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayId(String localGatewayId);

        /**
         * <p>
         * The ID of the local gateway route table.
         * </p>
         * 
         * @param localGatewayRouteTableId
         *        The ID of the local gateway route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableId(String localGatewayRouteTableId);

        /**
         * <p>
         * The state of the association.
         * </p>
         * 
         * @param state
         *        The state of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The tags assigned to the association.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the association.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the association.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String localGatewayRouteTableVirtualInterfaceGroupAssociationId;

        private String localGatewayVirtualInterfaceGroupId;

        private String localGatewayId;

        private String localGatewayRouteTableId;

        private String state;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LocalGatewayRouteTableVirtualInterfaceGroupAssociation model) {
            localGatewayRouteTableVirtualInterfaceGroupAssociationId(model.localGatewayRouteTableVirtualInterfaceGroupAssociationId);
            localGatewayVirtualInterfaceGroupId(model.localGatewayVirtualInterfaceGroupId);
            localGatewayId(model.localGatewayId);
            localGatewayRouteTableId(model.localGatewayRouteTableId);
            state(model.state);
            tags(model.tags);
        }

        public final String getLocalGatewayRouteTableVirtualInterfaceGroupAssociationId() {
            return localGatewayRouteTableVirtualInterfaceGroupAssociationId;
        }

        @Override
        public final Builder localGatewayRouteTableVirtualInterfaceGroupAssociationId(
                String localGatewayRouteTableVirtualInterfaceGroupAssociationId) {
            this.localGatewayRouteTableVirtualInterfaceGroupAssociationId = localGatewayRouteTableVirtualInterfaceGroupAssociationId;
            return this;
        }

        public final void setLocalGatewayRouteTableVirtualInterfaceGroupAssociationId(
                String localGatewayRouteTableVirtualInterfaceGroupAssociationId) {
            this.localGatewayRouteTableVirtualInterfaceGroupAssociationId = localGatewayRouteTableVirtualInterfaceGroupAssociationId;
        }

        public final String getLocalGatewayVirtualInterfaceGroupId() {
            return localGatewayVirtualInterfaceGroupId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        public final void setLocalGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
        }

        public final String getLocalGatewayId() {
            return localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        public final String getLocalGatewayRouteTableId() {
            return localGatewayRouteTableId;
        }

        @Override
        public final Builder localGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        public final void setLocalGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public LocalGatewayRouteTableVirtualInterfaceGroupAssociation build() {
            return new LocalGatewayRouteTableVirtualInterfaceGroupAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
