/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a set of permissions for a security group rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpPermission implements SdkPojo, Serializable, ToCopyableBuilder<IpPermission.Builder, IpPermission> {
    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(IpPermission::fromPort))
            .setter(setter(Builder::fromPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort")
                    .unmarshallLocationName("fromPort").build()).build();

    private static final SdkField<String> IP_PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(IpPermission::ipProtocol))
            .setter(setter(Builder::ipProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpProtocol")
                    .unmarshallLocationName("ipProtocol").build()).build();

    private static final SdkField<List<IpRange>> IP_RANGES_FIELD = SdkField
            .<List<IpRange>> builder(MarshallingType.LIST)
            .getter(getter(IpPermission::ipRanges))
            .setter(setter(Builder::ipRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRanges")
                    .unmarshallLocationName("ipRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Ipv6Range>> IPV6_RANGES_FIELD = SdkField
            .<List<Ipv6Range>> builder(MarshallingType.LIST)
            .getter(getter(IpPermission::ipv6Ranges))
            .setter(setter(Builder::ipv6Ranges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Ranges")
                    .unmarshallLocationName("ipv6Ranges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipv6Range> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv6Range::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<PrefixListId>> PREFIX_LIST_IDS_FIELD = SdkField
            .<List<PrefixListId>> builder(MarshallingType.LIST)
            .getter(getter(IpPermission::prefixListIds))
            .setter(setter(Builder::prefixListIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListIds")
                    .unmarshallLocationName("prefixListIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PrefixListId> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrefixListId::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> TO_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(IpPermission::toPort))
            .setter(setter(Builder::toPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort")
                    .unmarshallLocationName("toPort").build()).build();

    private static final SdkField<List<UserIdGroupPair>> USER_ID_GROUP_PAIRS_FIELD = SdkField
            .<List<UserIdGroupPair>> builder(MarshallingType.LIST)
            .getter(getter(IpPermission::userIdGroupPairs))
            .setter(setter(Builder::userIdGroupPairs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups")
                    .unmarshallLocationName("groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<UserIdGroupPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserIdGroupPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_PORT_FIELD,
            IP_PROTOCOL_FIELD, IP_RANGES_FIELD, IPV6_RANGES_FIELD, PREFIX_LIST_IDS_FIELD, TO_PORT_FIELD,
            USER_ID_GROUP_PAIRS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer fromPort;

    private final String ipProtocol;

    private final List<IpRange> ipRanges;

    private final List<Ipv6Range> ipv6Ranges;

    private final List<PrefixListId> prefixListIds;

    private final Integer toPort;

    private final List<UserIdGroupPair> userIdGroupPairs;

    private IpPermission(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.ipRanges = builder.ipRanges;
        this.ipv6Ranges = builder.ipv6Ranges;
        this.prefixListIds = builder.prefixListIds;
        this.toPort = builder.toPort;
        this.userIdGroupPairs = builder.userIdGroupPairs;
    }

    /**
     * <p>
     * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of <code>-1</code>
     * indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     * </p>
     * 
     * @return The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of
     *         <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify
     *         all codes.
     */
    public Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number (see
     * <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
     * </p>
     * <p>
     * [VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying
     * <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>, <code>icmp</code>, or
     * <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code>,
     * <code>udp</code>, and <code>icmp</code>, you must specify a port range. For <code>icmpv6</code>, the port range
     * is optional; if you omit the port range, traffic for all types and codes is allowed.
     * </p>
     * 
     * @return The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or
     *         number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol
     *         Numbers</a>).</p>
     *         <p>
     *         [VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules,
     *         specifying <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>,
     *         <code>icmp</code>, or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you
     *         specify. For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range.
     *         For <code>icmpv6</code>, the port range is optional; if you omit the port range, traffic for all types
     *         and codes is allowed.
     */
    public String ipProtocol() {
        return ipProtocol;
    }

    /**
     * Returns true if the IpRanges property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIpRanges() {
        return ipRanges != null && !(ipRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IPv4 ranges.
     */
    public List<IpRange> ipRanges() {
        return ipRanges;
    }

    /**
     * Returns true if the Ipv6Ranges property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIpv6Ranges() {
        return ipv6Ranges != null && !(ipv6Ranges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [VPC only] The IPv6 ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpv6Ranges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return [VPC only] The IPv6 ranges.
     */
    public List<Ipv6Range> ipv6Ranges() {
        return ipv6Ranges;
    }

    /**
     * Returns true if the PrefixListIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPrefixListIds() {
        return prefixListIds != null && !(prefixListIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [VPC only] The prefix list IDs for an AWS service. With outbound rules, this is the AWS service to access through
     * a VPC endpoint from instances associated with the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrefixListIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return [VPC only] The prefix list IDs for an AWS service. With outbound rules, this is the AWS service to access
     *         through a VPC endpoint from instances associated with the security group.
     */
    public List<PrefixListId> prefixListIds() {
        return prefixListIds;
    }

    /**
     * <p>
     * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code> indicates
     * all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     * </p>
     * 
     * @return The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code>
     *         indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     */
    public Integer toPort() {
        return toPort;
    }

    /**
     * Returns true if the UserIdGroupPairs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasUserIdGroupPairs() {
        return userIdGroupPairs != null && !(userIdGroupPairs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security group and AWS account ID pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserIdGroupPairs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The security group and AWS account ID pairs.
     */
    public List<UserIdGroupPair> userIdGroupPairs() {
        return userIdGroupPairs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(ipRanges());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Ranges());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListIds());
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        hashCode = 31 * hashCode + Objects.hashCode(userIdGroupPairs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpPermission)) {
            return false;
        }
        IpPermission other = (IpPermission) obj;
        return Objects.equals(fromPort(), other.fromPort()) && Objects.equals(ipProtocol(), other.ipProtocol())
                && Objects.equals(ipRanges(), other.ipRanges()) && Objects.equals(ipv6Ranges(), other.ipv6Ranges())
                && Objects.equals(prefixListIds(), other.prefixListIds()) && Objects.equals(toPort(), other.toPort())
                && Objects.equals(userIdGroupPairs(), other.userIdGroupPairs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IpPermission").add("FromPort", fromPort()).add("IpProtocol", ipProtocol())
                .add("IpRanges", ipRanges()).add("Ipv6Ranges", ipv6Ranges()).add("PrefixListIds", prefixListIds())
                .add("ToPort", toPort()).add("UserIdGroupPairs", userIdGroupPairs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FromPort":
            return Optional.ofNullable(clazz.cast(fromPort()));
        case "IpProtocol":
            return Optional.ofNullable(clazz.cast(ipProtocol()));
        case "IpRanges":
            return Optional.ofNullable(clazz.cast(ipRanges()));
        case "Ipv6Ranges":
            return Optional.ofNullable(clazz.cast(ipv6Ranges()));
        case "PrefixListIds":
            return Optional.ofNullable(clazz.cast(prefixListIds()));
        case "ToPort":
            return Optional.ofNullable(clazz.cast(toPort()));
        case "UserIdGroupPairs":
            return Optional.ofNullable(clazz.cast(userIdGroupPairs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpPermission, T> g) {
        return obj -> g.apply((IpPermission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpPermission> {
        /**
         * <p>
         * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of
         * <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all
         * codes.
         * </p>
         * 
         * @param fromPort
         *        The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of
         *        <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must
         *        specify all codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number
         * (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
         * </p>
         * <p>
         * [VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying
         * <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>, <code>icmp</code>, or
         * <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For
         * <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range. For
         * <code>icmpv6</code>, the port range is optional; if you omit the port range, traffic for all types and codes
         * is allowed.
         * </p>
         * 
         * @param ipProtocol
         *        The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or
         *        number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol
         *        Numbers</a>).</p>
         *        <p>
         *        [VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules,
         *        specifying <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>,
         *        <code>icmp</code>, or <code>icmpv6</code> allows traffic on all ports, regardless of any port range
         *        you specify. For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port
         *        range. For <code>icmpv6</code>, the port range is optional; if you omit the port range, traffic for
         *        all types and codes is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * The IPv4 ranges.
         * </p>
         * 
         * @param ipRanges
         *        The IPv4 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRanges(Collection<IpRange> ipRanges);

        /**
         * <p>
         * The IPv4 ranges.
         * </p>
         * 
         * @param ipRanges
         *        The IPv4 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRanges(IpRange... ipRanges);

        /**
         * <p>
         * The IPv4 ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpRange>.Builder} avoiding the need to
         * create one manually via {@link List<IpRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpRange>.Builder#build()} is called immediately and its
         * result is passed to {@link #ipRanges(List<IpRange>)}.
         * 
         * @param ipRanges
         *        a consumer that will call methods on {@link List<IpRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipRanges(List<IpRange>)
         */
        Builder ipRanges(Consumer<IpRange.Builder>... ipRanges);

        /**
         * <p>
         * [VPC only] The IPv6 ranges.
         * </p>
         * 
         * @param ipv6Ranges
         *        [VPC only] The IPv6 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Ranges(Collection<Ipv6Range> ipv6Ranges);

        /**
         * <p>
         * [VPC only] The IPv6 ranges.
         * </p>
         * 
         * @param ipv6Ranges
         *        [VPC only] The IPv6 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Ranges(Ipv6Range... ipv6Ranges);

        /**
         * <p>
         * [VPC only] The IPv6 ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Ipv6Range>.Builder} avoiding the need to
         * create one manually via {@link List<Ipv6Range>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ipv6Range>.Builder#build()} is called immediately and its
         * result is passed to {@link #ipv6Ranges(List<Ipv6Range>)}.
         * 
         * @param ipv6Ranges
         *        a consumer that will call methods on {@link List<Ipv6Range>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Ranges(List<Ipv6Range>)
         */
        Builder ipv6Ranges(Consumer<Ipv6Range.Builder>... ipv6Ranges);

        /**
         * <p>
         * [VPC only] The prefix list IDs for an AWS service. With outbound rules, this is the AWS service to access
         * through a VPC endpoint from instances associated with the security group.
         * </p>
         * 
         * @param prefixListIds
         *        [VPC only] The prefix list IDs for an AWS service. With outbound rules, this is the AWS service to
         *        access through a VPC endpoint from instances associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(Collection<PrefixListId> prefixListIds);

        /**
         * <p>
         * [VPC only] The prefix list IDs for an AWS service. With outbound rules, this is the AWS service to access
         * through a VPC endpoint from instances associated with the security group.
         * </p>
         * 
         * @param prefixListIds
         *        [VPC only] The prefix list IDs for an AWS service. With outbound rules, this is the AWS service to
         *        access through a VPC endpoint from instances associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(PrefixListId... prefixListIds);

        /**
         * <p>
         * [VPC only] The prefix list IDs for an AWS service. With outbound rules, this is the AWS service to access
         * through a VPC endpoint from instances associated with the security group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PrefixListId>.Builder} avoiding the need to
         * create one manually via {@link List<PrefixListId>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrefixListId>.Builder#build()} is called immediately and its
         * result is passed to {@link #prefixListIds(List<PrefixListId>)}.
         * 
         * @param prefixListIds
         *        a consumer that will call methods on {@link List<PrefixListId>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prefixListIds(List<PrefixListId>)
         */
        Builder prefixListIds(Consumer<PrefixListId.Builder>... prefixListIds);

        /**
         * <p>
         * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code>
         * indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
         * </p>
         * 
         * @param toPort
         *        The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of
         *        <code>-1</code> indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must
         *        specify all codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * The security group and AWS account ID pairs.
         * </p>
         * 
         * @param userIdGroupPairs
         *        The security group and AWS account ID pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs);

        /**
         * <p>
         * The security group and AWS account ID pairs.
         * </p>
         * 
         * @param userIdGroupPairs
         *        The security group and AWS account ID pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdGroupPairs(UserIdGroupPair... userIdGroupPairs);

        /**
         * <p>
         * The security group and AWS account ID pairs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserIdGroupPair>.Builder} avoiding the need
         * to create one manually via {@link List<UserIdGroupPair>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserIdGroupPair>.Builder#build()} is called immediately and
         * its result is passed to {@link #userIdGroupPairs(List<UserIdGroupPair>)}.
         * 
         * @param userIdGroupPairs
         *        a consumer that will call methods on {@link List<UserIdGroupPair>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userIdGroupPairs(List<UserIdGroupPair>)
         */
        Builder userIdGroupPairs(Consumer<UserIdGroupPair.Builder>... userIdGroupPairs);
    }

    static final class BuilderImpl implements Builder {
        private Integer fromPort;

        private String ipProtocol;

        private List<IpRange> ipRanges = DefaultSdkAutoConstructList.getInstance();

        private List<Ipv6Range> ipv6Ranges = DefaultSdkAutoConstructList.getInstance();

        private List<PrefixListId> prefixListIds = DefaultSdkAutoConstructList.getInstance();

        private Integer toPort;

        private List<UserIdGroupPair> userIdGroupPairs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpPermission model) {
            fromPort(model.fromPort);
            ipProtocol(model.ipProtocol);
            ipRanges(model.ipRanges);
            ipv6Ranges(model.ipv6Ranges);
            prefixListIds(model.prefixListIds);
            toPort(model.toPort);
            userIdGroupPairs(model.userIdGroupPairs);
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Collection<IpRange.Builder> getIpRanges() {
            return ipRanges != null ? ipRanges.stream().map(IpRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipRanges(Collection<IpRange> ipRanges) {
            this.ipRanges = IpRangeListCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(IpRange... ipRanges) {
            ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(Consumer<IpRange.Builder>... ipRanges) {
            ipRanges(Stream.of(ipRanges).map(c -> IpRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpRanges(Collection<IpRange.BuilderImpl> ipRanges) {
            this.ipRanges = IpRangeListCopier.copyFromBuilder(ipRanges);
        }

        public final Collection<Ipv6Range.Builder> getIpv6Ranges() {
            return ipv6Ranges != null ? ipv6Ranges.stream().map(Ipv6Range::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Ranges(Collection<Ipv6Range> ipv6Ranges) {
            this.ipv6Ranges = Ipv6RangeListCopier.copy(ipv6Ranges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Ranges(Ipv6Range... ipv6Ranges) {
            ipv6Ranges(Arrays.asList(ipv6Ranges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Ranges(Consumer<Ipv6Range.Builder>... ipv6Ranges) {
            ipv6Ranges(Stream.of(ipv6Ranges).map(c -> Ipv6Range.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6Ranges(Collection<Ipv6Range.BuilderImpl> ipv6Ranges) {
            this.ipv6Ranges = Ipv6RangeListCopier.copyFromBuilder(ipv6Ranges);
        }

        public final Collection<PrefixListId.Builder> getPrefixListIds() {
            return prefixListIds != null ? prefixListIds.stream().map(PrefixListId::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder prefixListIds(Collection<PrefixListId> prefixListIds) {
            this.prefixListIds = PrefixListIdListCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(PrefixListId... prefixListIds) {
            prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(Consumer<PrefixListId.Builder>... prefixListIds) {
            prefixListIds(Stream.of(prefixListIds).map(c -> PrefixListId.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPrefixListIds(Collection<PrefixListId.BuilderImpl> prefixListIds) {
            this.prefixListIds = PrefixListIdListCopier.copyFromBuilder(prefixListIds);
        }

        public final Integer getToPort() {
            return toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final Collection<UserIdGroupPair.Builder> getUserIdGroupPairs() {
            return userIdGroupPairs != null ? userIdGroupPairs.stream().map(UserIdGroupPair::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairListCopier.copy(userIdGroupPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(UserIdGroupPair... userIdGroupPairs) {
            userIdGroupPairs(Arrays.asList(userIdGroupPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(Consumer<UserIdGroupPair.Builder>... userIdGroupPairs) {
            userIdGroupPairs(Stream.of(userIdGroupPairs).map(c -> UserIdGroupPair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserIdGroupPairs(Collection<UserIdGroupPair.BuilderImpl> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairListCopier.copyFromBuilder(userIdGroupPairs);
        }

        @Override
        public IpPermission build() {
            return new IpPermission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
