/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeKeyPairsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeKeyPairsRequest.Builder, DescribeKeyPairsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeKeyPairsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> KEY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeKeyPairsRequest::keyNames))
            .setter(setter(Builder::keyNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName")
                    .unmarshallLocationName("KeyName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("KeyName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("KeyName").unmarshallLocationName("KeyName").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> KEY_PAIR_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeKeyPairsRequest::keyPairIds))
            .setter(setter(Builder::keyPairIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPairId")
                    .unmarshallLocationName("KeyPairId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("KeyPairId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("KeyPairId").unmarshallLocationName("KeyPairId").build())
                                            .build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            KEY_NAMES_FIELD, KEY_PAIR_IDS_FIELD));

    private final List<Filter> filters;

    private final List<String> keyNames;

    private final List<String> keyPairIds;

    private DescribeKeyPairsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.keyNames = builder.keyNames;
        this.keyPairIds = builder.keyPairIds;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>fingerprint</code> - The fingerprint of the key pair.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>key-name</code> - The name of the key pair.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>fingerprint</code> - The fingerprint of the key pair.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>key-name</code> - The name of the key pair.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * Returns true if the KeyNames property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasKeyNames() {
        return keyNames != null && !(keyNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key pair names.
     * </p>
     * <p>
     * Default: Describes all your key pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeyNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key pair names.</p>
     *         <p>
     *         Default: Describes all your key pairs.
     */
    public List<String> keyNames() {
        return keyNames;
    }

    /**
     * Returns true if the KeyPairIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasKeyPairIds() {
        return keyPairIds != null && !(keyPairIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the key pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeyPairIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the key pairs.
     */
    public List<String> keyPairIds() {
        return keyPairIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(keyNames());
        hashCode = 31 * hashCode + Objects.hashCode(keyPairIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyPairsRequest)) {
            return false;
        }
        DescribeKeyPairsRequest other = (DescribeKeyPairsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(keyNames(), other.keyNames())
                && Objects.equals(keyPairIds(), other.keyPairIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeKeyPairsRequest").add("Filters", filters()).add("KeyNames", keyNames())
                .add("KeyPairIds", keyPairIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "KeyNames":
            return Optional.ofNullable(clazz.cast(keyNames()));
        case "KeyPairIds":
            return Optional.ofNullable(clazz.cast(keyPairIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeKeyPairsRequest, T> g) {
        return obj -> g.apply((DescribeKeyPairsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeKeyPairsRequest> {
        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>fingerprint</code> - The fingerprint of the key pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key-name</code> - The name of the key pair.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>fingerprint</code> - The fingerprint of the key pair.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>key-name</code> - The name of the key pair.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>fingerprint</code> - The fingerprint of the key pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key-name</code> - The name of the key pair.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>fingerprint</code> - The fingerprint of the key pair.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>key-name</code> - The name of the key pair.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>fingerprint</code> - The fingerprint of the key pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key-name</code> - The name of the key pair.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The key pair names.
         * </p>
         * <p>
         * Default: Describes all your key pairs.
         * </p>
         * 
         * @param keyNames
         *        The key pair names.</p>
         *        <p>
         *        Default: Describes all your key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyNames(Collection<String> keyNames);

        /**
         * <p>
         * The key pair names.
         * </p>
         * <p>
         * Default: Describes all your key pairs.
         * </p>
         * 
         * @param keyNames
         *        The key pair names.</p>
         *        <p>
         *        Default: Describes all your key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyNames(String... keyNames);

        /**
         * <p>
         * The IDs of the key pairs.
         * </p>
         * 
         * @param keyPairIds
         *        The IDs of the key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairIds(Collection<String> keyPairIds);

        /**
         * <p>
         * The IDs of the key pairs.
         * </p>
         * 
         * @param keyPairIds
         *        The IDs of the key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairIds(String... keyPairIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> keyNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> keyPairIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyPairsRequest model) {
            super(model);
            filters(model.filters);
            keyNames(model.keyNames);
            keyPairIds(model.keyPairIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getKeyNames() {
            return keyNames;
        }

        @Override
        public final Builder keyNames(Collection<String> keyNames) {
            this.keyNames = KeyNameStringListCopier.copy(keyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyNames(String... keyNames) {
            keyNames(Arrays.asList(keyNames));
            return this;
        }

        public final void setKeyNames(Collection<String> keyNames) {
            this.keyNames = KeyNameStringListCopier.copy(keyNames);
        }

        public final Collection<String> getKeyPairIds() {
            return keyPairIds;
        }

        @Override
        public final Builder keyPairIds(Collection<String> keyPairIds) {
            this.keyPairIds = KeyPairIdStringListCopier.copy(keyPairIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairIds(String... keyPairIds) {
            keyPairIds(Arrays.asList(keyPairIds));
            return this;
        }

        public final void setKeyPairIds(Collection<String> keyPairIds) {
            this.keyPairIds = KeyPairIdStringListCopier.copy(keyPairIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeKeyPairsRequest build() {
            return new DescribeKeyPairsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
