/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceStatusResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeInstanceStatusResponse.Builder, DescribeInstanceStatusResponse> {
    private static final SdkField<List<InstanceStatus>> INSTANCE_STATUSES_FIELD = SdkField
            .<List<InstanceStatus>> builder(MarshallingType.LIST)
            .getter(getter(DescribeInstanceStatusResponse::instanceStatuses))
            .setter(setter(Builder::instanceStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatusSet")
                    .unmarshallLocationName("instanceStatusSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeInstanceStatusResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_STATUSES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<InstanceStatus> instanceStatuses;

    private final String nextToken;

    private DescribeInstanceStatusResponse(BuilderImpl builder) {
        super(builder);
        this.instanceStatuses = builder.instanceStatuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the InstanceStatuses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasInstanceStatuses() {
        return instanceStatuses != null && !(instanceStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the status of the instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the status of the instances.
     */
    public List<InstanceStatus> instanceStatuses() {
        return instanceStatuses;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceStatusResponse)) {
            return false;
        }
        DescribeInstanceStatusResponse other = (DescribeInstanceStatusResponse) obj;
        return Objects.equals(instanceStatuses(), other.instanceStatuses()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeInstanceStatusResponse").add("InstanceStatuses", instanceStatuses())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceStatuses":
            return Optional.ofNullable(clazz.cast(instanceStatuses()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceStatusResponse, T> g) {
        return obj -> g.apply((DescribeInstanceStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstanceStatusResponse> {
        /**
         * <p>
         * Information about the status of the instances.
         * </p>
         * 
         * @param instanceStatuses
         *        Information about the status of the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatuses(Collection<InstanceStatus> instanceStatuses);

        /**
         * <p>
         * Information about the status of the instances.
         * </p>
         * 
         * @param instanceStatuses
         *        Information about the status of the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatuses(InstanceStatus... instanceStatuses);

        /**
         * <p>
         * Information about the status of the instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceStatus>.Builder} avoiding the need
         * to create one manually via {@link List<InstanceStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceStatus>.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceStatuses(List<InstanceStatus>)}.
         * 
         * @param instanceStatuses
         *        a consumer that will call methods on {@link List<InstanceStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceStatuses(List<InstanceStatus>)
         */
        Builder instanceStatuses(Consumer<InstanceStatus.Builder>... instanceStatuses);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<InstanceStatus> instanceStatuses = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceStatusResponse model) {
            super(model);
            instanceStatuses(model.instanceStatuses);
            nextToken(model.nextToken);
        }

        public final Collection<InstanceStatus.Builder> getInstanceStatuses() {
            return instanceStatuses != null ? instanceStatuses.stream().map(InstanceStatus::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceStatuses(Collection<InstanceStatus> instanceStatuses) {
            this.instanceStatuses = InstanceStatusListCopier.copy(instanceStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatuses(InstanceStatus... instanceStatuses) {
            instanceStatuses(Arrays.asList(instanceStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatuses(Consumer<InstanceStatus.Builder>... instanceStatuses) {
            instanceStatuses(Stream.of(instanceStatuses).map(c -> InstanceStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceStatuses(Collection<InstanceStatus.BuilderImpl> instanceStatuses) {
            this.instanceStatuses = InstanceStatusListCopier.copyFromBuilder(instanceStatuses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceStatusResponse build() {
            return new DescribeInstanceStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
