/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLocalGatewayRouteResponse extends Ec2Response implements
        ToCopyableBuilder<CreateLocalGatewayRouteResponse.Builder, CreateLocalGatewayRouteResponse> {
    private static final SdkField<LocalGatewayRoute> ROUTE_FIELD = SdkField
            .<LocalGatewayRoute> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateLocalGatewayRouteResponse::route))
            .setter(setter(Builder::route))
            .constructor(LocalGatewayRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Route")
                    .unmarshallLocationName("route").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_FIELD));

    private final LocalGatewayRoute route;

    private CreateLocalGatewayRouteResponse(BuilderImpl builder) {
        super(builder);
        this.route = builder.route;
    }

    /**
     * <p>
     * Information about the route.
     * </p>
     * 
     * @return Information about the route.
     */
    public LocalGatewayRoute route() {
        return route;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(route());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocalGatewayRouteResponse)) {
            return false;
        }
        CreateLocalGatewayRouteResponse other = (CreateLocalGatewayRouteResponse) obj;
        return Objects.equals(route(), other.route());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateLocalGatewayRouteResponse").add("Route", route()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Route":
            return Optional.ofNullable(clazz.cast(route()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLocalGatewayRouteResponse, T> g) {
        return obj -> g.apply((CreateLocalGatewayRouteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateLocalGatewayRouteResponse> {
        /**
         * <p>
         * Information about the route.
         * </p>
         * 
         * @param route
         *        Information about the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder route(LocalGatewayRoute route);

        /**
         * <p>
         * Information about the route.
         * </p>
         * This is a convenience that creates an instance of the {@link LocalGatewayRoute.Builder} avoiding the need to
         * create one manually via {@link LocalGatewayRoute#builder()}.
         *
         * When the {@link Consumer} completes, {@link LocalGatewayRoute.Builder#build()} is called immediately and its
         * result is passed to {@link #route(LocalGatewayRoute)}.
         * 
         * @param route
         *        a consumer that will call methods on {@link LocalGatewayRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #route(LocalGatewayRoute)
         */
        default Builder route(Consumer<LocalGatewayRoute.Builder> route) {
            return route(LocalGatewayRoute.builder().applyMutation(route).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private LocalGatewayRoute route;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocalGatewayRouteResponse model) {
            super(model);
            route(model.route);
        }

        public final LocalGatewayRoute.Builder getRoute() {
            return route != null ? route.toBuilder() : null;
        }

        @Override
        public final Builder route(LocalGatewayRoute route) {
            this.route = route;
            return this;
        }

        public final void setRoute(LocalGatewayRoute.BuilderImpl route) {
            this.route = route != null ? route.build() : null;
        }

        @Override
        public CreateLocalGatewayRouteResponse build() {
            return new CreateLocalGatewayRouteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
