/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an address range that is provisioned for use with your AWS resources through bring your own IP
 * addresses (BYOIP).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ByoipCidr implements SdkPojo, Serializable, ToCopyableBuilder<ByoipCidr.Builder, ByoipCidr> {
    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ByoipCidr::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("cidr").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ByoipCidr::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ByoipCidr::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ByoipCidr::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, DESCRIPTION_FIELD,
            STATUS_MESSAGE_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cidr;

    private final String description;

    private final String statusMessage;

    private final String state;

    private ByoipCidr(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.description = builder.description;
        this.statusMessage = builder.statusMessage;
        this.state = builder.state;
    }

    /**
     * <p>
     * The address range, in CIDR notation.
     * </p>
     * 
     * @return The address range, in CIDR notation.
     */
    public String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The description of the address range.
     * </p>
     * 
     * @return The description of the address range.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Upon success, contains the ID of the address pool. Otherwise, contains an error message.
     * </p>
     * 
     * @return Upon success, contains the ID of the address pool. Otherwise, contains an error message.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The state of the address pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ByoipCidrState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the address pool.
     * @see ByoipCidrState
     */
    public ByoipCidrState state() {
        return ByoipCidrState.fromValue(state);
    }

    /**
     * <p>
     * The state of the address pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ByoipCidrState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the address pool.
     * @see ByoipCidrState
     */
    public String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByoipCidr)) {
            return false;
        }
        ByoipCidr other = (ByoipCidr) obj;
        return Objects.equals(cidr(), other.cidr()) && Objects.equals(description(), other.description())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ByoipCidr").add("Cidr", cidr()).add("Description", description())
                .add("StatusMessage", statusMessage()).add("State", stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ByoipCidr, T> g) {
        return obj -> g.apply((ByoipCidr) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ByoipCidr> {
        /**
         * <p>
         * The address range, in CIDR notation.
         * </p>
         * 
         * @param cidr
         *        The address range, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The description of the address range.
         * </p>
         * 
         * @param description
         *        The description of the address range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Upon success, contains the ID of the address pool. Otherwise, contains an error message.
         * </p>
         * 
         * @param statusMessage
         *        Upon success, contains the ID of the address pool. Otherwise, contains an error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The state of the address pool.
         * </p>
         * 
         * @param state
         *        The state of the address pool.
         * @see ByoipCidrState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ByoipCidrState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the address pool.
         * </p>
         * 
         * @param state
         *        The state of the address pool.
         * @see ByoipCidrState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ByoipCidrState
         */
        Builder state(ByoipCidrState state);
    }

    static final class BuilderImpl implements Builder {
        private String cidr;

        private String description;

        private String statusMessage;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(ByoipCidr model) {
            cidr(model.cidr);
            description(model.description);
            statusMessage(model.statusMessage);
            state(model.state);
        }

        public final String getCidr() {
            return cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ByoipCidrState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public ByoipCidr build() {
            return new ByoipCidr(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
