/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.PlacementGroupIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.PlacementGroupStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePlacementGroupsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribePlacementGroupsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribePlacementGroupsRequest.getter(DescribePlacementGroupsRequest::filters)).setter(DescribePlacementGroupsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribePlacementGroupsRequest.getter(DescribePlacementGroupsRequest::groupNames)).setter(DescribePlacementGroupsRequest.setter(Builder::groupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("groupName").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribePlacementGroupsRequest.getter(DescribePlacementGroupsRequest::groupIds)).setter(DescribePlacementGroupsRequest.setter(Builder::groupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("GroupId").build(), ListTrait.builder().memberLocationName("GroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("GroupId").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, GROUP_NAMES_FIELD, GROUP_IDS_FIELD));
    private final List<Filter> filters;
    private final List<String> groupNames;
    private final List<String> groupIds;

    private DescribePlacementGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.groupNames = builder.groupNames;
        this.groupIds = builder.groupIds;
    }

    public boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public boolean hasGroupNames() {
        return this.groupNames != null && !(this.groupNames instanceof SdkAutoConstructList);
    }

    public List<String> groupNames() {
        return this.groupNames;
    }

    public boolean hasGroupIds() {
        return this.groupIds != null && !(this.groupIds instanceof SdkAutoConstructList);
    }

    public List<String> groupIds() {
        return this.groupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlacementGroupsRequest)) {
            return false;
        }
        DescribePlacementGroupsRequest other = (DescribePlacementGroupsRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.groupNames(), other.groupNames()) && Objects.equals(this.groupIds(), other.groupIds());
    }

    public String toString() {
        return ToString.builder((String)"DescribePlacementGroupsRequest").add("Filters", this.filters()).add("GroupNames", this.groupNames()).add("GroupIds", this.groupIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "GroupNames": {
                return Optional.ofNullable(clazz.cast(this.groupNames()));
            }
            case "GroupIds": {
                return Optional.ofNullable(clazz.cast(this.groupIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePlacementGroupsRequest, T> g) {
        return obj -> g.apply((DescribePlacementGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<String> groupNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> groupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlacementGroupsRequest model) {
            super(model);
            this.filters(model.filters);
            this.groupNames(model.groupNames);
            this.groupIds(model.groupIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getGroupNames() {
            return this.groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = PlacementGroupStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String ... groupNames) {
            this.groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = PlacementGroupStringListCopier.copy(groupNames);
        }

        public final Collection<String> getGroupIds() {
            return this.groupIds;
        }

        @Override
        public final Builder groupIds(Collection<String> groupIds) {
            this.groupIds = PlacementGroupIdStringListCopier.copy(groupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIds(String ... groupIds) {
            this.groupIds(Arrays.asList(groupIds));
            return this;
        }

        public final void setGroupIds(Collection<String> groupIds) {
            this.groupIds = PlacementGroupIdStringListCopier.copy(groupIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePlacementGroupsRequest build() {
            return new DescribePlacementGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePlacementGroupsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder groupNames(Collection<String> var1);

        public Builder groupNames(String ... var1);

        public Builder groupIds(Collection<String> var1);

        public Builder groupIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

