/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.EbsEncryptionSupport;
import software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EbsInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EbsInfo> {
    private static final SdkField<String> EBS_OPTIMIZED_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EbsInfo.getter(EbsInfo::ebsOptimizedSupportAsString)).setter(EbsInfo.setter(Builder::ebsOptimizedSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimizedSupport").unmarshallLocationName("ebsOptimizedSupport").build()}).build();
    private static final SdkField<String> ENCRYPTION_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EbsInfo.getter(EbsInfo::encryptionSupportAsString)).setter(EbsInfo.setter(Builder::encryptionSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionSupport").unmarshallLocationName("encryptionSupport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_OPTIMIZED_SUPPORT_FIELD, ENCRYPTION_SUPPORT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ebsOptimizedSupport;
    private final String encryptionSupport;

    private EbsInfo(BuilderImpl builder) {
        this.ebsOptimizedSupport = builder.ebsOptimizedSupport;
        this.encryptionSupport = builder.encryptionSupport;
    }

    public EbsOptimizedSupport ebsOptimizedSupport() {
        return EbsOptimizedSupport.fromValue(this.ebsOptimizedSupport);
    }

    public String ebsOptimizedSupportAsString() {
        return this.ebsOptimizedSupport;
    }

    public EbsEncryptionSupport encryptionSupport() {
        return EbsEncryptionSupport.fromValue(this.encryptionSupport);
    }

    public String encryptionSupportAsString() {
        return this.encryptionSupport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimizedSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionSupportAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsInfo)) {
            return false;
        }
        EbsInfo other = (EbsInfo)obj;
        return Objects.equals(this.ebsOptimizedSupportAsString(), other.ebsOptimizedSupportAsString()) && Objects.equals(this.encryptionSupportAsString(), other.encryptionSupportAsString());
    }

    public String toString() {
        return ToString.builder((String)"EbsInfo").add("EbsOptimizedSupport", (Object)this.ebsOptimizedSupportAsString()).add("EncryptionSupport", (Object)this.encryptionSupportAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EbsOptimizedSupport": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimizedSupportAsString()));
            }
            case "EncryptionSupport": {
                return Optional.ofNullable(clazz.cast(this.encryptionSupportAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsInfo, T> g) {
        return obj -> g.apply((EbsInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ebsOptimizedSupport;
        private String encryptionSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsInfo model) {
            this.ebsOptimizedSupport(model.ebsOptimizedSupport);
            this.encryptionSupport(model.encryptionSupport);
        }

        public final String getEbsOptimizedSupportAsString() {
            return this.ebsOptimizedSupport;
        }

        @Override
        public final Builder ebsOptimizedSupport(String ebsOptimizedSupport) {
            this.ebsOptimizedSupport = ebsOptimizedSupport;
            return this;
        }

        @Override
        public final Builder ebsOptimizedSupport(EbsOptimizedSupport ebsOptimizedSupport) {
            this.ebsOptimizedSupport(ebsOptimizedSupport == null ? null : ebsOptimizedSupport.toString());
            return this;
        }

        public final void setEbsOptimizedSupport(String ebsOptimizedSupport) {
            this.ebsOptimizedSupport = ebsOptimizedSupport;
        }

        public final String getEncryptionSupportAsString() {
            return this.encryptionSupport;
        }

        @Override
        public final Builder encryptionSupport(String encryptionSupport) {
            this.encryptionSupport = encryptionSupport;
            return this;
        }

        @Override
        public final Builder encryptionSupport(EbsEncryptionSupport encryptionSupport) {
            this.encryptionSupport(encryptionSupport == null ? null : encryptionSupport.toString());
            return this;
        }

        public final void setEncryptionSupport(String encryptionSupport) {
            this.encryptionSupport = encryptionSupport;
        }

        public EbsInfo build() {
            return new EbsInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EbsInfo> {
        public Builder ebsOptimizedSupport(String var1);

        public Builder ebsOptimizedSupport(EbsOptimizedSupport var1);

        public Builder encryptionSupport(String var1);

        public Builder encryptionSupport(EbsEncryptionSupport var1);
    }
}

