/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.OfferingClassType;
import software.amazon.awssdk.services.ec2.model.OfferingTypeValues;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedInstancesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeReservedInstancesRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeReservedInstancesRequest.getter(DescribeReservedInstancesRequest::filters)).setter(DescribeReservedInstancesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<String> OFFERING_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservedInstancesRequest.getter(DescribeReservedInstancesRequest::offeringClassAsString)).setter(DescribeReservedInstancesRequest.setter(Builder::offeringClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingClass").unmarshallLocationName("OfferingClass").build()}).build();
    private static final SdkField<List<String>> RESERVED_INSTANCES_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeReservedInstancesRequest.getter(DescribeReservedInstancesRequest::reservedInstancesIds)).setter(DescribeReservedInstancesRequest.setter(Builder::reservedInstancesIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId").unmarshallLocationName("ReservedInstancesId").build(), ListTrait.builder().memberLocationName("ReservedInstancesId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId").unmarshallLocationName("ReservedInstancesId").build()}).build()).build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservedInstancesRequest.getter(DescribeReservedInstancesRequest::offeringTypeAsString)).setter(DescribeReservedInstancesRequest.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").unmarshallLocationName("offeringType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, OFFERING_CLASS_FIELD, RESERVED_INSTANCES_IDS_FIELD, OFFERING_TYPE_FIELD));
    private final List<Filter> filters;
    private final String offeringClass;
    private final List<String> reservedInstancesIds;
    private final String offeringType;

    private DescribeReservedInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.offeringClass = builder.offeringClass;
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.offeringType = builder.offeringType;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(this.offeringClass);
    }

    public String offeringClassAsString() {
        return this.offeringClass;
    }

    public List<String> reservedInstancesIds() {
        return this.reservedInstancesIds;
    }

    public OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(this.offeringType);
    }

    public String offeringTypeAsString() {
        return this.offeringType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesRequest)) {
            return false;
        }
        DescribeReservedInstancesRequest other = (DescribeReservedInstancesRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.offeringClassAsString(), other.offeringClassAsString()) && Objects.equals(this.reservedInstancesIds(), other.reservedInstancesIds()) && Objects.equals(this.offeringTypeAsString(), other.offeringTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedInstancesRequest").add("Filters", this.filters()).add("OfferingClass", (Object)this.offeringClassAsString()).add("ReservedInstancesIds", this.reservedInstancesIds()).add("OfferingType", (Object)this.offeringTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "OfferingClass": {
                return Optional.ofNullable(clazz.cast(this.offeringClassAsString()));
            }
            case "ReservedInstancesIds": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesIds()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedInstancesRequest, T> g) {
        return obj -> g.apply((DescribeReservedInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private String offeringClass;
        private List<String> reservedInstancesIds = DefaultSdkAutoConstructList.getInstance();
        private String offeringType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesRequest model) {
            super(model);
            this.filters(model.filters);
            this.offeringClass(model.offeringClass);
            this.reservedInstancesIds(model.reservedInstancesIds);
            this.offeringType(model.offeringType);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getOfferingClass() {
            return this.offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final Collection<String> getReservedInstancesIds() {
            return this.reservedInstancesIds;
        }

        @Override
        public final Builder reservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(String ... reservedInstancesIds) {
            this.reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        public final void setReservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedInstancesRequest build() {
            return new DescribeReservedInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedInstancesRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder offeringClass(String var1);

        public Builder offeringClass(OfferingClassType var1);

        public Builder reservedInstancesIds(Collection<String> var1);

        public Builder reservedInstancesIds(String ... var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingTypeValues var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

