/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ClassicLinkInstance;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.GroupIdentifierUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class ClassicLinkInstanceUnmarshaller
implements Unmarshaller<ClassicLinkInstance, StaxUnmarshallerContext> {
    private static final ClassicLinkInstanceUnmarshaller INSTANCE = new ClassicLinkInstanceUnmarshaller();

    public ClassicLinkInstance unmarshall(StaxUnmarshallerContext context) throws Exception {
        ClassicLinkInstance.Builder classicLinkInstance;
        block9: {
            classicLinkInstance = ClassicLinkInstance.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<GroupIdentifier> groups = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    classicLinkInstance.groups(groups);
                    classicLinkInstance.tags(tags);
                    break block9;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("groupSet", targetDepth)) {
                        groups = new ArrayList<GroupIdentifier>();
                        continue;
                    }
                    if (context.testExpression("groupSet/item", targetDepth)) {
                        groups.add(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceId", targetDepth)) {
                        classicLinkInstance.instanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (context.testExpression("tagSet/item", targetDepth)) {
                        tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("vpcId", targetDepth)) continue;
                    classicLinkInstance.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            classicLinkInstance.groups(groups);
            classicLinkInstance.tags(tags);
        }
        return (ClassicLinkInstance)classicLinkInstance.build();
    }

    public static ClassicLinkInstanceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

