/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.Volume;

public class DescribeVolumesIterable
implements SdkIterable<DescribeVolumesResponse> {
    private final EC2Client client;
    private final DescribeVolumesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVolumesIterable(EC2Client client, DescribeVolumesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeVolumesResponseFetcher();
    }

    public Iterator<DescribeVolumesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Volume> volumes() {
        Function<DescribeVolumesResponse, Iterator> getIterator = response -> {
            if (response != null && response.volumes() != null) {
                return response.volumes().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeVolumesIterable resume(DescribeVolumesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeVolumesIterable(this.client, (DescribeVolumesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeVolumesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeVolumesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeVolumesResponseFetcher
    implements SyncPageFetcher<DescribeVolumesResponse> {
        private DescribeVolumesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVolumesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeVolumesResponse nextPage(DescribeVolumesResponse previousPage) {
            if (previousPage == null) {
                return DescribeVolumesIterable.this.client.describeVolumes(DescribeVolumesIterable.this.firstRequest);
            }
            return DescribeVolumesIterable.this.client.describeVolumes((DescribeVolumesRequest)((Object)DescribeVolumesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

