/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.VolumeStatusDetails;
import software.amazon.awssdk.services.ec2.model.VolumeStatusDetailsListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VolumeStatusInfo
implements ToCopyableBuilder<Builder, VolumeStatusInfo> {
    private final List<VolumeStatusDetails> details;
    private final String status;

    private VolumeStatusInfo(BuilderImpl builder) {
        this.details = builder.details;
        this.status = builder.status;
    }

    public List<VolumeStatusDetails> details() {
        return this.details;
    }

    public VolumeStatusInfoStatus status() {
        return VolumeStatusInfoStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusInfo)) {
            return false;
        }
        VolumeStatusInfo other = (VolumeStatusInfo)obj;
        return Objects.equals(this.details(), other.details()) && Objects.equals(this.statusString(), other.statusString());
    }

    public String toString() {
        return ToString.builder((String)"VolumeStatusInfo").add("Details", this.details()).add("Status", (Object)this.statusString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Details": {
                return Optional.of(clazz.cast(this.details()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<VolumeStatusDetails> details;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusInfo model) {
            this.details(model.details);
            this.status(model.status);
        }

        public final Collection<VolumeStatusDetails.Builder> getDetails() {
            return this.details != null ? (Collection)this.details.stream().map(VolumeStatusDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder details(Collection<VolumeStatusDetails> details) {
            this.details = VolumeStatusDetailsListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(VolumeStatusDetails ... details) {
            this.details(Arrays.asList(details));
            return this;
        }

        public final void setDetails(Collection<VolumeStatusDetails.BuilderImpl> details) {
            this.details = VolumeStatusDetailsListCopier.copyFromBuilder(details);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VolumeStatusInfoStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public VolumeStatusInfo build() {
            return new VolumeStatusInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VolumeStatusInfo> {
        public Builder details(Collection<VolumeStatusDetails> var1);

        public Builder details(VolumeStatusDetails ... var1);

        public Builder status(String var1);

        public Builder status(VolumeStatusInfoStatus var1);
    }
}

