/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservationValue
implements ToCopyableBuilder<Builder, ReservationValue> {
    private final String hourlyPrice;
    private final String remainingTotalValue;
    private final String remainingUpfrontValue;

    private ReservationValue(BuilderImpl builder) {
        this.hourlyPrice = builder.hourlyPrice;
        this.remainingTotalValue = builder.remainingTotalValue;
        this.remainingUpfrontValue = builder.remainingUpfrontValue;
    }

    public String hourlyPrice() {
        return this.hourlyPrice;
    }

    public String remainingTotalValue() {
        return this.remainingTotalValue;
    }

    public String remainingUpfrontValue() {
        return this.remainingUpfrontValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.remainingTotalValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.remainingUpfrontValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationValue)) {
            return false;
        }
        ReservationValue other = (ReservationValue)obj;
        return Objects.equals(this.hourlyPrice(), other.hourlyPrice()) && Objects.equals(this.remainingTotalValue(), other.remainingTotalValue()) && Objects.equals(this.remainingUpfrontValue(), other.remainingUpfrontValue());
    }

    public String toString() {
        return ToString.builder((String)"ReservationValue").add("HourlyPrice", (Object)this.hourlyPrice()).add("RemainingTotalValue", (Object)this.remainingTotalValue()).add("RemainingUpfrontValue", (Object)this.remainingUpfrontValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HourlyPrice": {
                return Optional.of(clazz.cast(this.hourlyPrice()));
            }
            case "RemainingTotalValue": {
                return Optional.of(clazz.cast(this.remainingTotalValue()));
            }
            case "RemainingUpfrontValue": {
                return Optional.of(clazz.cast(this.remainingUpfrontValue()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String hourlyPrice;
        private String remainingTotalValue;
        private String remainingUpfrontValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationValue model) {
            this.hourlyPrice(model.hourlyPrice);
            this.remainingTotalValue(model.remainingTotalValue);
            this.remainingUpfrontValue(model.remainingUpfrontValue);
        }

        public final String getHourlyPrice() {
            return this.hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getRemainingTotalValue() {
            return this.remainingTotalValue;
        }

        @Override
        public final Builder remainingTotalValue(String remainingTotalValue) {
            this.remainingTotalValue = remainingTotalValue;
            return this;
        }

        public final void setRemainingTotalValue(String remainingTotalValue) {
            this.remainingTotalValue = remainingTotalValue;
        }

        public final String getRemainingUpfrontValue() {
            return this.remainingUpfrontValue;
        }

        @Override
        public final Builder remainingUpfrontValue(String remainingUpfrontValue) {
            this.remainingUpfrontValue = remainingUpfrontValue;
            return this;
        }

        public final void setRemainingUpfrontValue(String remainingUpfrontValue) {
            this.remainingUpfrontValue = remainingUpfrontValue;
        }

        public ReservationValue build() {
            return new ReservationValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservationValue> {
        public Builder hourlyPrice(String var1);

        public Builder remainingTotalValue(String var1);

        public Builder remainingUpfrontValue(String var1);
    }
}

