/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachment;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceIpv6Address;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceIpv6AddressesListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePrivateIpAddress;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePrivateIpAddressListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NetworkInterface
implements ToCopyableBuilder<Builder, NetworkInterface> {
    private final NetworkInterfaceAssociation association;
    private final NetworkInterfaceAttachment attachment;
    private final String availabilityZone;
    private final String description;
    private final List<GroupIdentifier> groups;
    private final String interfaceType;
    private final List<NetworkInterfaceIpv6Address> ipv6Addresses;
    private final String macAddress;
    private final String networkInterfaceId;
    private final String ownerId;
    private final String privateDnsName;
    private final String privateIpAddress;
    private final List<NetworkInterfacePrivateIpAddress> privateIpAddresses;
    private final String requesterId;
    private final Boolean requesterManaged;
    private final Boolean sourceDestCheck;
    private final String status;
    private final String subnetId;
    private final List<Tag> tagSet;
    private final String vpcId;

    private NetworkInterface(BuilderImpl builder) {
        this.association = builder.association;
        this.attachment = builder.attachment;
        this.availabilityZone = builder.availabilityZone;
        this.description = builder.description;
        this.groups = builder.groups;
        this.interfaceType = builder.interfaceType;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.macAddress = builder.macAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.ownerId = builder.ownerId;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.requesterId = builder.requesterId;
        this.requesterManaged = builder.requesterManaged;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.status = builder.status;
        this.subnetId = builder.subnetId;
        this.tagSet = builder.tagSet;
        this.vpcId = builder.vpcId;
    }

    public NetworkInterfaceAssociation association() {
        return this.association;
    }

    public NetworkInterfaceAttachment attachment() {
        return this.attachment;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String description() {
        return this.description;
    }

    public List<GroupIdentifier> groups() {
        return this.groups;
    }

    public NetworkInterfaceType interfaceType() {
        return NetworkInterfaceType.fromValue(this.interfaceType);
    }

    public String interfaceTypeString() {
        return this.interfaceType;
    }

    public List<NetworkInterfaceIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public List<NetworkInterfacePrivateIpAddress> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public String requesterId() {
        return this.requesterId;
    }

    public Boolean requesterManaged() {
        return this.requesterManaged;
    }

    public Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public NetworkInterfaceStatus status() {
        return NetworkInterfaceStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public List<Tag> tagSet() {
        return this.tagSet;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.association());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterManaged());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface)obj;
        return Objects.equals(this.association(), other.association()) && Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.interfaceTypeString(), other.interfaceTypeString()) && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.requesterId(), other.requesterId()) && Objects.equals(this.requesterManaged(), other.requesterManaged()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.tagSet(), other.tagSet()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        return ToString.builder((String)"NetworkInterface").add("Association", (Object)this.association()).add("Attachment", (Object)this.attachment()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Description", (Object)this.description()).add("Groups", this.groups()).add("InterfaceType", (Object)this.interfaceTypeString()).add("Ipv6Addresses", this.ipv6Addresses()).add("MacAddress", (Object)this.macAddress()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("OwnerId", (Object)this.ownerId()).add("PrivateDnsName", (Object)this.privateDnsName()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("PrivateIpAddresses", this.privateIpAddresses()).add("RequesterId", (Object)this.requesterId()).add("RequesterManaged", (Object)this.requesterManaged()).add("SourceDestCheck", (Object)this.sourceDestCheck()).add("Status", (Object)this.statusString()).add("SubnetId", (Object)this.subnetId()).add("TagSet", this.tagSet()).add("VpcId", (Object)this.vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Association": {
                return Optional.of(clazz.cast(this.association()));
            }
            case "Attachment": {
                return Optional.of(clazz.cast(this.attachment()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Groups": {
                return Optional.of(clazz.cast(this.groups()));
            }
            case "InterfaceType": {
                return Optional.of(clazz.cast(this.interfaceTypeString()));
            }
            case "Ipv6Addresses": {
                return Optional.of(clazz.cast(this.ipv6Addresses()));
            }
            case "MacAddress": {
                return Optional.of(clazz.cast(this.macAddress()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
            case "OwnerId": {
                return Optional.of(clazz.cast(this.ownerId()));
            }
            case "PrivateDnsName": {
                return Optional.of(clazz.cast(this.privateDnsName()));
            }
            case "PrivateIpAddress": {
                return Optional.of(clazz.cast(this.privateIpAddress()));
            }
            case "PrivateIpAddresses": {
                return Optional.of(clazz.cast(this.privateIpAddresses()));
            }
            case "RequesterId": {
                return Optional.of(clazz.cast(this.requesterId()));
            }
            case "RequesterManaged": {
                return Optional.of(clazz.cast(this.requesterManaged()));
            }
            case "SourceDestCheck": {
                return Optional.of(clazz.cast(this.sourceDestCheck()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "TagSet": {
                return Optional.of(clazz.cast(this.tagSet()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private NetworkInterfaceAssociation association;
        private NetworkInterfaceAttachment attachment;
        private String availabilityZone;
        private String description;
        private List<GroupIdentifier> groups;
        private String interfaceType;
        private List<NetworkInterfaceIpv6Address> ipv6Addresses;
        private String macAddress;
        private String networkInterfaceId;
        private String ownerId;
        private String privateDnsName;
        private String privateIpAddress;
        private List<NetworkInterfacePrivateIpAddress> privateIpAddresses;
        private String requesterId;
        private Boolean requesterManaged;
        private Boolean sourceDestCheck;
        private String status;
        private String subnetId;
        private List<Tag> tagSet;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            this.association(model.association);
            this.attachment(model.attachment);
            this.availabilityZone(model.availabilityZone);
            this.description(model.description);
            this.groups(model.groups);
            this.interfaceType(model.interfaceType);
            this.ipv6Addresses(model.ipv6Addresses);
            this.macAddress(model.macAddress);
            this.networkInterfaceId(model.networkInterfaceId);
            this.ownerId(model.ownerId);
            this.privateDnsName(model.privateDnsName);
            this.privateIpAddress(model.privateIpAddress);
            this.privateIpAddresses(model.privateIpAddresses);
            this.requesterId(model.requesterId);
            this.requesterManaged(model.requesterManaged);
            this.sourceDestCheck(model.sourceDestCheck);
            this.status(model.status);
            this.subnetId(model.subnetId);
            this.tagSet(model.tagSet);
            this.vpcId(model.vpcId);
        }

        public final NetworkInterfaceAssociation.Builder getAssociation() {
            return this.association != null ? this.association.toBuilder() : null;
        }

        @Override
        public final Builder association(NetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(NetworkInterfaceAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        public final NetworkInterfaceAttachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        @Override
        public final Builder attachment(NetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(NetworkInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<GroupIdentifier.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final String getInterfaceType() {
            return this.interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        @Override
        public final Builder interfaceType(NetworkInterfaceType interfaceType) {
            this.interfaceType(interfaceType.toString());
            return this;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        public final Collection<NetworkInterfaceIpv6Address.Builder> getIpv6Addresses() {
            return this.ipv6Addresses != null ? (Collection)this.ipv6Addresses.stream().map(NetworkInterfaceIpv6Address::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Addresses(Collection<NetworkInterfaceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = NetworkInterfaceIpv6AddressesListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(NetworkInterfaceIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<NetworkInterfaceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = NetworkInterfaceIpv6AddressesListCopier.copyFromBuilder(ipv6Addresses);
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<NetworkInterfacePrivateIpAddress.Builder> getPrivateIpAddresses() {
            return this.privateIpAddresses != null ? (Collection)this.privateIpAddresses.stream().map(NetworkInterfacePrivateIpAddress::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder privateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = NetworkInterfacePrivateIpAddressListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(NetworkInterfacePrivateIpAddress ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<NetworkInterfacePrivateIpAddress.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = NetworkInterfacePrivateIpAddressListCopier.copyFromBuilder(privateIpAddresses);
        }

        public final String getRequesterId() {
            return this.requesterId;
        }

        @Override
        public final Builder requesterId(String requesterId) {
            this.requesterId = requesterId;
            return this;
        }

        public final void setRequesterId(String requesterId) {
            this.requesterId = requesterId;
        }

        public final Boolean getRequesterManaged() {
            return this.requesterManaged;
        }

        @Override
        public final Builder requesterManaged(Boolean requesterManaged) {
            this.requesterManaged = requesterManaged;
            return this;
        }

        public final void setRequesterManaged(Boolean requesterManaged) {
            this.requesterManaged = requesterManaged;
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkInterfaceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<Tag.Builder> getTagSet() {
            return this.tagSet != null ? (Collection)this.tagSet.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSet(Collection<Tag> tagSet) {
            this.tagSet = TagListCopier.copy(tagSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSet(Tag ... tagSet) {
            this.tagSet(Arrays.asList(tagSet));
            return this;
        }

        public final void setTagSet(Collection<Tag.BuilderImpl> tagSet) {
            this.tagSet = TagListCopier.copyFromBuilder(tagSet);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public NetworkInterface build() {
            return new NetworkInterface(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkInterface> {
        public Builder association(NetworkInterfaceAssociation var1);

        default public Builder association(Consumer<NetworkInterfaceAssociation.Builder> association) {
            return this.association((NetworkInterfaceAssociation)((NetworkInterfaceAssociation.Builder)NetworkInterfaceAssociation.builder().apply(association)).build());
        }

        public Builder attachment(NetworkInterfaceAttachment var1);

        default public Builder attachment(Consumer<NetworkInterfaceAttachment.Builder> attachment) {
            return this.attachment((NetworkInterfaceAttachment)((NetworkInterfaceAttachment.Builder)NetworkInterfaceAttachment.builder().apply(attachment)).build());
        }

        public Builder availabilityZone(String var1);

        public Builder description(String var1);

        public Builder groups(Collection<GroupIdentifier> var1);

        public Builder groups(GroupIdentifier ... var1);

        public Builder interfaceType(String var1);

        public Builder interfaceType(NetworkInterfaceType var1);

        public Builder ipv6Addresses(Collection<NetworkInterfaceIpv6Address> var1);

        public Builder ipv6Addresses(NetworkInterfaceIpv6Address ... var1);

        public Builder macAddress(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder ownerId(String var1);

        public Builder privateDnsName(String var1);

        public Builder privateIpAddress(String var1);

        public Builder privateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> var1);

        public Builder privateIpAddresses(NetworkInterfacePrivateIpAddress ... var1);

        public Builder requesterId(String var1);

        public Builder requesterManaged(Boolean var1);

        public Builder sourceDestCheck(Boolean var1);

        public Builder status(String var1);

        public Builder status(NetworkInterfaceStatus var1);

        public Builder subnetId(String var1);

        public Builder tagSet(Collection<Tag> var1);

        public Builder tagSet(Tag ... var1);

        public Builder vpcId(String var1);
    }
}

