/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.LoadPermissionListRequestCopier;
import software.amazon.awssdk.services.ec2.model.LoadPermissionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoadPermissionModifications
implements ToCopyableBuilder<Builder, LoadPermissionModifications> {
    private final List<LoadPermissionRequest> add;
    private final List<LoadPermissionRequest> remove;

    private LoadPermissionModifications(BuilderImpl builder) {
        this.add = builder.add;
        this.remove = builder.remove;
    }

    public List<LoadPermissionRequest> add() {
        return this.add;
    }

    public List<LoadPermissionRequest> remove() {
        return this.remove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.add());
        hashCode = 31 * hashCode + Objects.hashCode(this.remove());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadPermissionModifications)) {
            return false;
        }
        LoadPermissionModifications other = (LoadPermissionModifications)obj;
        return Objects.equals(this.add(), other.add()) && Objects.equals(this.remove(), other.remove());
    }

    public String toString() {
        return ToString.builder((String)"LoadPermissionModifications").add("Add", this.add()).add("Remove", this.remove()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Add": {
                return Optional.of(clazz.cast(this.add()));
            }
            case "Remove": {
                return Optional.of(clazz.cast(this.remove()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<LoadPermissionRequest> add;
        private List<LoadPermissionRequest> remove;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadPermissionModifications model) {
            this.add(model.add);
            this.remove(model.remove);
        }

        public final Collection<LoadPermissionRequest.Builder> getAdd() {
            return this.add != null ? (Collection)this.add.stream().map(LoadPermissionRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder add(Collection<LoadPermissionRequest> add) {
            this.add = LoadPermissionListRequestCopier.copy(add);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(LoadPermissionRequest ... add) {
            this.add(Arrays.asList(add));
            return this;
        }

        public final void setAdd(Collection<LoadPermissionRequest.BuilderImpl> add) {
            this.add = LoadPermissionListRequestCopier.copyFromBuilder(add);
        }

        public final Collection<LoadPermissionRequest.Builder> getRemove() {
            return this.remove != null ? (Collection)this.remove.stream().map(LoadPermissionRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remove(Collection<LoadPermissionRequest> remove) {
            this.remove = LoadPermissionListRequestCopier.copy(remove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remove(LoadPermissionRequest ... remove) {
            this.remove(Arrays.asList(remove));
            return this;
        }

        public final void setRemove(Collection<LoadPermissionRequest.BuilderImpl> remove) {
            this.remove = LoadPermissionListRequestCopier.copyFromBuilder(remove);
        }

        public LoadPermissionModifications build() {
            return new LoadPermissionModifications(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadPermissionModifications> {
        public Builder add(Collection<LoadPermissionRequest> var1);

        public Builder add(LoadPermissionRequest ... var1);

        public Builder remove(Collection<LoadPermissionRequest> var1);

        public Builder remove(LoadPermissionRequest ... var1);
    }
}

