/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.ElasticGpuHealth;
import software.amazon.awssdk.services.ec2.model.ElasticGpuState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ElasticGpus
implements ToCopyableBuilder<Builder, ElasticGpus> {
    private final String elasticGpuId;
    private final String availabilityZone;
    private final String elasticGpuType;
    private final ElasticGpuHealth elasticGpuHealth;
    private final String elasticGpuState;
    private final String instanceId;

    private ElasticGpus(BuilderImpl builder) {
        this.elasticGpuId = builder.elasticGpuId;
        this.availabilityZone = builder.availabilityZone;
        this.elasticGpuType = builder.elasticGpuType;
        this.elasticGpuHealth = builder.elasticGpuHealth;
        this.elasticGpuState = builder.elasticGpuState;
        this.instanceId = builder.instanceId;
    }

    public String elasticGpuId() {
        return this.elasticGpuId;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String elasticGpuType() {
        return this.elasticGpuType;
    }

    public ElasticGpuHealth elasticGpuHealth() {
        return this.elasticGpuHealth;
    }

    public ElasticGpuState elasticGpuState() {
        return ElasticGpuState.fromValue(this.elasticGpuState);
    }

    public String elasticGpuStateString() {
        return this.elasticGpuState;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticGpuId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticGpuType());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticGpuHealth());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticGpuStateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticGpus)) {
            return false;
        }
        ElasticGpus other = (ElasticGpus)obj;
        return Objects.equals(this.elasticGpuId(), other.elasticGpuId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.elasticGpuType(), other.elasticGpuType()) && Objects.equals(this.elasticGpuHealth(), other.elasticGpuHealth()) && Objects.equals(this.elasticGpuStateString(), other.elasticGpuStateString()) && Objects.equals(this.instanceId(), other.instanceId());
    }

    public String toString() {
        return ToString.builder((String)"ElasticGpus").add("ElasticGpuId", (Object)this.elasticGpuId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("ElasticGpuType", (Object)this.elasticGpuType()).add("ElasticGpuHealth", (Object)this.elasticGpuHealth()).add("ElasticGpuState", (Object)this.elasticGpuStateString()).add("InstanceId", (Object)this.instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticGpuId": {
                return Optional.of(clazz.cast(this.elasticGpuId()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "ElasticGpuType": {
                return Optional.of(clazz.cast(this.elasticGpuType()));
            }
            case "ElasticGpuHealth": {
                return Optional.of(clazz.cast(this.elasticGpuHealth()));
            }
            case "ElasticGpuState": {
                return Optional.of(clazz.cast(this.elasticGpuStateString()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String elasticGpuId;
        private String availabilityZone;
        private String elasticGpuType;
        private ElasticGpuHealth elasticGpuHealth;
        private String elasticGpuState;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticGpus model) {
            this.elasticGpuId(model.elasticGpuId);
            this.availabilityZone(model.availabilityZone);
            this.elasticGpuType(model.elasticGpuType);
            this.elasticGpuHealth(model.elasticGpuHealth);
            this.elasticGpuState(model.elasticGpuState);
            this.instanceId(model.instanceId);
        }

        public final String getElasticGpuId() {
            return this.elasticGpuId;
        }

        @Override
        public final Builder elasticGpuId(String elasticGpuId) {
            this.elasticGpuId = elasticGpuId;
            return this;
        }

        public final void setElasticGpuId(String elasticGpuId) {
            this.elasticGpuId = elasticGpuId;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getElasticGpuType() {
            return this.elasticGpuType;
        }

        @Override
        public final Builder elasticGpuType(String elasticGpuType) {
            this.elasticGpuType = elasticGpuType;
            return this;
        }

        public final void setElasticGpuType(String elasticGpuType) {
            this.elasticGpuType = elasticGpuType;
        }

        public final ElasticGpuHealth.Builder getElasticGpuHealth() {
            return this.elasticGpuHealth != null ? this.elasticGpuHealth.toBuilder() : null;
        }

        @Override
        public final Builder elasticGpuHealth(ElasticGpuHealth elasticGpuHealth) {
            this.elasticGpuHealth = elasticGpuHealth;
            return this;
        }

        public final void setElasticGpuHealth(ElasticGpuHealth.BuilderImpl elasticGpuHealth) {
            this.elasticGpuHealth = elasticGpuHealth != null ? elasticGpuHealth.build() : null;
        }

        public final String getElasticGpuState() {
            return this.elasticGpuState;
        }

        @Override
        public final Builder elasticGpuState(String elasticGpuState) {
            this.elasticGpuState = elasticGpuState;
            return this;
        }

        @Override
        public final Builder elasticGpuState(ElasticGpuState elasticGpuState) {
            this.elasticGpuState(elasticGpuState.toString());
            return this;
        }

        public final void setElasticGpuState(String elasticGpuState) {
            this.elasticGpuState = elasticGpuState;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public ElasticGpus build() {
            return new ElasticGpus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticGpus> {
        public Builder elasticGpuId(String var1);

        public Builder availabilityZone(String var1);

        public Builder elasticGpuType(String var1);

        public Builder elasticGpuHealth(ElasticGpuHealth var1);

        default public Builder elasticGpuHealth(Consumer<ElasticGpuHealth.Builder> elasticGpuHealth) {
            return this.elasticGpuHealth((ElasticGpuHealth)((ElasticGpuHealth.Builder)ElasticGpuHealth.builder().apply(elasticGpuHealth)).build());
        }

        public Builder elasticGpuState(String var1);

        public Builder elasticGpuState(ElasticGpuState var1);

        public Builder instanceId(String var1);
    }
}

