/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.BundleTask;
import software.amazon.awssdk.services.ec2.model.BundleTaskListCopier;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeBundleTasksResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeBundleTasksResponse> {
    private final List<BundleTask> bundleTasks;

    private DescribeBundleTasksResponse(BuilderImpl builder) {
        super(builder);
        this.bundleTasks = builder.bundleTasks;
    }

    public List<BundleTask> bundleTasks() {
        return this.bundleTasks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleTasks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBundleTasksResponse)) {
            return false;
        }
        DescribeBundleTasksResponse other = (DescribeBundleTasksResponse)((Object)obj);
        return Objects.equals(this.bundleTasks(), other.bundleTasks());
    }

    public String toString() {
        return ToString.builder((String)"DescribeBundleTasksResponse").add("BundleTasks", this.bundleTasks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BundleTasks": {
                return Optional.of(clazz.cast(this.bundleTasks()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<BundleTask> bundleTasks;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBundleTasksResponse model) {
            this.bundleTasks(model.bundleTasks);
        }

        public final Collection<BundleTask.Builder> getBundleTasks() {
            return this.bundleTasks != null ? (Collection)this.bundleTasks.stream().map(BundleTask::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bundleTasks(Collection<BundleTask> bundleTasks) {
            this.bundleTasks = BundleTaskListCopier.copy(bundleTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundleTasks(BundleTask ... bundleTasks) {
            this.bundleTasks(Arrays.asList(bundleTasks));
            return this;
        }

        public final void setBundleTasks(Collection<BundleTask.BuilderImpl> bundleTasks) {
            this.bundleTasks = BundleTaskListCopier.copyFromBuilder(bundleTasks);
        }

        @Override
        public DescribeBundleTasksResponse build() {
            return new DescribeBundleTasksResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeBundleTasksResponse> {
        public Builder bundleTasks(Collection<BundleTask> var1);

        public Builder bundleTasks(BundleTask ... var1);
    }
}

