/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.DomainType;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AllocateAddressResponse
extends EC2Response
implements ToCopyableBuilder<Builder, AllocateAddressResponse> {
    private final String publicIp;
    private final String allocationId;
    private final String domain;

    private AllocateAddressResponse(BuilderImpl builder) {
        super(builder);
        this.publicIp = builder.publicIp;
        this.allocationId = builder.allocationId;
        this.domain = builder.domain;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public DomainType domain() {
        return DomainType.fromValue(this.domain);
    }

    public String domainString() {
        return this.domain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateAddressResponse)) {
            return false;
        }
        AllocateAddressResponse other = (AllocateAddressResponse)((Object)obj);
        return Objects.equals(this.publicIp(), other.publicIp()) && Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.domainString(), other.domainString());
    }

    public String toString() {
        return ToString.builder((String)"AllocateAddressResponse").add("PublicIp", (Object)this.publicIp()).add("AllocationId", (Object)this.allocationId()).add("Domain", (Object)this.domainString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicIp": {
                return Optional.of(clazz.cast(this.publicIp()));
            }
            case "AllocationId": {
                return Optional.of(clazz.cast(this.allocationId()));
            }
            case "Domain": {
                return Optional.of(clazz.cast(this.domainString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private String publicIp;
        private String allocationId;
        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateAddressResponse model) {
            this.publicIp(model.publicIp);
            this.allocationId(model.allocationId);
            this.domain(model.domain);
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public AllocateAddressResponse build() {
            return new AllocateAddressResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, AllocateAddressResponse> {
        public Builder publicIp(String var1);

        public Builder allocationId(String var1);

        public Builder domain(String var1);

        public Builder domain(DomainType var1);
    }
}

