/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UserIdGroupPair
implements ToCopyableBuilder<Builder, UserIdGroupPair> {
    private final String description;
    private final String groupId;
    private final String groupName;
    private final String peeringStatus;
    private final String userId;
    private final String vpcId;
    private final String vpcPeeringConnectionId;

    private UserIdGroupPair(BuilderImpl builder) {
        this.description = builder.description;
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.peeringStatus = builder.peeringStatus;
        this.userId = builder.userId;
        this.vpcId = builder.vpcId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    public String description() {
        return this.description;
    }

    public String groupId() {
        return this.groupId;
    }

    public String groupName() {
        return this.groupName;
    }

    public String peeringStatus() {
        return this.peeringStatus;
    }

    public String userId() {
        return this.userId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String vpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.peeringStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnectionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserIdGroupPair)) {
            return false;
        }
        UserIdGroupPair other = (UserIdGroupPair)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.peeringStatus(), other.peeringStatus()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    public String toString() {
        return ToString.builder((String)"UserIdGroupPair").add("Description", (Object)this.description()).add("GroupId", (Object)this.groupId()).add("GroupName", (Object)this.groupName()).add("PeeringStatus", (Object)this.peeringStatus()).add("UserId", (Object)this.userId()).add("VpcId", (Object)this.vpcId()).add("VpcPeeringConnectionId", (Object)this.vpcPeeringConnectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "GroupId": {
                return Optional.of(clazz.cast(this.groupId()));
            }
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "PeeringStatus": {
                return Optional.of(clazz.cast(this.peeringStatus()));
            }
            case "UserId": {
                return Optional.of(clazz.cast(this.userId()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "VpcPeeringConnectionId": {
                return Optional.of(clazz.cast(this.vpcPeeringConnectionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String groupId;
        private String groupName;
        private String peeringStatus;
        private String userId;
        private String vpcId;
        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UserIdGroupPair model) {
            this.description(model.description);
            this.groupId(model.groupId);
            this.groupName(model.groupName);
            this.peeringStatus(model.peeringStatus);
            this.userId(model.userId);
            this.vpcId(model.vpcId);
            this.vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getPeeringStatus() {
            return this.peeringStatus;
        }

        @Override
        public final Builder peeringStatus(String peeringStatus) {
            this.peeringStatus = peeringStatus;
            return this;
        }

        public final void setPeeringStatus(String peeringStatus) {
            this.peeringStatus = peeringStatus;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        public UserIdGroupPair build() {
            return new UserIdGroupPair(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UserIdGroupPair> {
        public Builder description(String var1);

        public Builder groupId(String var1);

        public Builder groupName(String var1);

        public Builder peeringStatus(String var1);

        public Builder userId(String var1);

        public Builder vpcId(String var1);

        public Builder vpcPeeringConnectionId(String var1);
    }
}

