/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGatewayIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEgressOnlyInternetGatewaysRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DescribeEgressOnlyInternetGatewaysRequest> {
    private final List<String> egressOnlyInternetGatewayIds;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeEgressOnlyInternetGatewaysRequest(BuilderImpl builder) {
        super(builder);
        this.egressOnlyInternetGatewayIds = builder.egressOnlyInternetGatewayIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<String> egressOnlyInternetGatewayIds() {
        return this.egressOnlyInternetGatewayIds;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.egressOnlyInternetGatewayIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEgressOnlyInternetGatewaysRequest)) {
            return false;
        }
        DescribeEgressOnlyInternetGatewaysRequest other = (DescribeEgressOnlyInternetGatewaysRequest)((Object)obj);
        return Objects.equals(this.egressOnlyInternetGatewayIds(), other.egressOnlyInternetGatewayIds()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEgressOnlyInternetGatewaysRequest").add("EgressOnlyInternetGatewayIds", this.egressOnlyInternetGatewayIds()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EgressOnlyInternetGatewayIds": {
                return Optional.of(clazz.cast(this.egressOnlyInternetGatewayIds()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private List<String> egressOnlyInternetGatewayIds;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEgressOnlyInternetGatewaysRequest model) {
            this.egressOnlyInternetGatewayIds(model.egressOnlyInternetGatewayIds);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getEgressOnlyInternetGatewayIds() {
            return this.egressOnlyInternetGatewayIds;
        }

        @Override
        public final Builder egressOnlyInternetGatewayIds(Collection<String> egressOnlyInternetGatewayIds) {
            this.egressOnlyInternetGatewayIds = EgressOnlyInternetGatewayIdListCopier.copy(egressOnlyInternetGatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressOnlyInternetGatewayIds(String ... egressOnlyInternetGatewayIds) {
            this.egressOnlyInternetGatewayIds(Arrays.asList(egressOnlyInternetGatewayIds));
            return this;
        }

        public final void setEgressOnlyInternetGatewayIds(Collection<String> egressOnlyInternetGatewayIds) {
            this.egressOnlyInternetGatewayIds = EgressOnlyInternetGatewayIdListCopier.copy(egressOnlyInternetGatewayIds);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeEgressOnlyInternetGatewaysRequest build() {
            return new DescribeEgressOnlyInternetGatewaysRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DescribeEgressOnlyInternetGatewaysRequest> {
        public Builder egressOnlyInternetGatewayIds(Collection<String> var1);

        public Builder egressOnlyInternetGatewayIds(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

