/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.BatchState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CancelSpotFleetRequestsSuccessItem
implements ToCopyableBuilder<Builder, CancelSpotFleetRequestsSuccessItem> {
    private final String currentSpotFleetRequestState;
    private final String previousSpotFleetRequestState;
    private final String spotFleetRequestId;

    private CancelSpotFleetRequestsSuccessItem(BuilderImpl builder) {
        this.currentSpotFleetRequestState = builder.currentSpotFleetRequestState;
        this.previousSpotFleetRequestState = builder.previousSpotFleetRequestState;
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    public BatchState currentSpotFleetRequestState() {
        return BatchState.fromValue(this.currentSpotFleetRequestState);
    }

    public String currentSpotFleetRequestStateString() {
        return this.currentSpotFleetRequestState;
    }

    public BatchState previousSpotFleetRequestState() {
        return BatchState.fromValue(this.previousSpotFleetRequestState);
    }

    public String previousSpotFleetRequestStateString() {
        return this.previousSpotFleetRequestState;
    }

    public String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currentSpotFleetRequestStateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousSpotFleetRequestStateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsSuccessItem)) {
            return false;
        }
        CancelSpotFleetRequestsSuccessItem other = (CancelSpotFleetRequestsSuccessItem)obj;
        return Objects.equals(this.currentSpotFleetRequestStateString(), other.currentSpotFleetRequestStateString()) && Objects.equals(this.previousSpotFleetRequestStateString(), other.previousSpotFleetRequestStateString()) && Objects.equals(this.spotFleetRequestId(), other.spotFleetRequestId());
    }

    public String toString() {
        return ToString.builder((String)"CancelSpotFleetRequestsSuccessItem").add("CurrentSpotFleetRequestState", (Object)this.currentSpotFleetRequestStateString()).add("PreviousSpotFleetRequestState", (Object)this.previousSpotFleetRequestStateString()).add("SpotFleetRequestId", (Object)this.spotFleetRequestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrentSpotFleetRequestState": {
                return Optional.of(clazz.cast(this.currentSpotFleetRequestStateString()));
            }
            case "PreviousSpotFleetRequestState": {
                return Optional.of(clazz.cast(this.previousSpotFleetRequestStateString()));
            }
            case "SpotFleetRequestId": {
                return Optional.of(clazz.cast(this.spotFleetRequestId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String currentSpotFleetRequestState;
        private String previousSpotFleetRequestState;
        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsSuccessItem model) {
            this.currentSpotFleetRequestState(model.currentSpotFleetRequestState);
            this.previousSpotFleetRequestState(model.previousSpotFleetRequestState);
            this.spotFleetRequestId(model.spotFleetRequestId);
        }

        public final String getCurrentSpotFleetRequestState() {
            return this.currentSpotFleetRequestState;
        }

        @Override
        public final Builder currentSpotFleetRequestState(String currentSpotFleetRequestState) {
            this.currentSpotFleetRequestState = currentSpotFleetRequestState;
            return this;
        }

        @Override
        public final Builder currentSpotFleetRequestState(BatchState currentSpotFleetRequestState) {
            this.currentSpotFleetRequestState(currentSpotFleetRequestState.toString());
            return this;
        }

        public final void setCurrentSpotFleetRequestState(String currentSpotFleetRequestState) {
            this.currentSpotFleetRequestState = currentSpotFleetRequestState;
        }

        public final String getPreviousSpotFleetRequestState() {
            return this.previousSpotFleetRequestState;
        }

        @Override
        public final Builder previousSpotFleetRequestState(String previousSpotFleetRequestState) {
            this.previousSpotFleetRequestState = previousSpotFleetRequestState;
            return this;
        }

        @Override
        public final Builder previousSpotFleetRequestState(BatchState previousSpotFleetRequestState) {
            this.previousSpotFleetRequestState(previousSpotFleetRequestState.toString());
            return this;
        }

        public final void setPreviousSpotFleetRequestState(String previousSpotFleetRequestState) {
            this.previousSpotFleetRequestState = previousSpotFleetRequestState;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        public CancelSpotFleetRequestsSuccessItem build() {
            return new CancelSpotFleetRequestsSuccessItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CancelSpotFleetRequestsSuccessItem> {
        public Builder currentSpotFleetRequestState(String var1);

        public Builder currentSpotFleetRequestState(BatchState var1);

        public Builder previousSpotFleetRequestState(String var1);

        public Builder previousSpotFleetRequestState(BatchState var1);

        public Builder spotFleetRequestId(String var1);
    }
}

