/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeFlowLogsRequestMarshaller
implements Marshaller<Request<DescribeFlowLogsRequest>, DescribeFlowLogsRequest> {
    public Request<DescribeFlowLogsRequest> marshall(DescribeFlowLogsRequest describeFlowLogsRequest) {
        List<String> describeFlowLogsRequestFlowLogIdsList;
        if (describeFlowLogsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeFlowLogsRequest, "EC2Client");
        request.addParameter("Action", "DescribeFlowLogs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeFlowLogsRequestFilterList = describeFlowLogsRequest.filter();
        if (describeFlowLogsRequestFilterList != null) {
            int filterListIndex = 1;
            for (Filter describeFlowLogsRequestFilterListValue : describeFlowLogsRequestFilterList) {
                List<String> filterValuesList;
                if (describeFlowLogsRequestFilterListValue.name() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString((String)describeFlowLogsRequestFilterListValue.name()));
                }
                if ((filterValuesList = describeFlowLogsRequestFilterListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if ((describeFlowLogsRequestFlowLogIdsList = describeFlowLogsRequest.flowLogIds()) != null) {
            int flowLogIdsListIndex = 1;
            for (String describeFlowLogsRequestFlowLogIdsListValue : describeFlowLogsRequestFlowLogIdsList) {
                if (describeFlowLogsRequestFlowLogIdsListValue != null) {
                    request.addParameter("FlowLogId." + flowLogIdsListIndex, StringUtils.fromString((String)describeFlowLogsRequestFlowLogIdsListValue));
                }
                ++flowLogIdsListIndex;
            }
        }
        if (describeFlowLogsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeFlowLogsRequest.maxResults()));
        }
        if (describeFlowLogsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeFlowLogsRequest.nextToken()));
        }
        return request;
    }
}

