/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesEbs;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScheduledInstancesBlockDeviceMapping
implements ToCopyableBuilder<Builder, ScheduledInstancesBlockDeviceMapping> {
    private final String deviceName;
    private final ScheduledInstancesEbs ebs;
    private final String noDevice;
    private final String virtualName;

    private ScheduledInstancesBlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
        this.virtualName = builder.virtualName;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public ScheduledInstancesEbs ebs() {
        return this.ebs;
    }

    public String noDevice() {
        return this.noDevice;
    }

    public String virtualName() {
        return this.virtualName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebs());
        hashCode = 31 * hashCode + Objects.hashCode(this.noDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesBlockDeviceMapping)) {
            return false;
        }
        ScheduledInstancesBlockDeviceMapping other = (ScheduledInstancesBlockDeviceMapping)obj;
        return Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.ebs(), other.ebs()) && Objects.equals(this.noDevice(), other.noDevice()) && Objects.equals(this.virtualName(), other.virtualName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deviceName() != null) {
            sb.append("DeviceName: ").append(this.deviceName()).append(",");
        }
        if (this.ebs() != null) {
            sb.append("Ebs: ").append(this.ebs()).append(",");
        }
        if (this.noDevice() != null) {
            sb.append("NoDevice: ").append(this.noDevice()).append(",");
        }
        if (this.virtualName() != null) {
            sb.append("VirtualName: ").append(this.virtualName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceName": {
                return Optional.of(clazz.cast(this.deviceName()));
            }
            case "Ebs": {
                return Optional.of(clazz.cast(this.ebs()));
            }
            case "NoDevice": {
                return Optional.of(clazz.cast(this.noDevice()));
            }
            case "VirtualName": {
                return Optional.of(clazz.cast(this.virtualName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceName;
        private ScheduledInstancesEbs ebs;
        private String noDevice;
        private String virtualName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesBlockDeviceMapping model) {
            this.deviceName(model.deviceName);
            this.ebs(model.ebs);
            this.noDevice(model.noDevice);
            this.virtualName(model.virtualName);
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final ScheduledInstancesEbs.Builder getEbs() {
            return this.ebs != null ? this.ebs.toBuilder() : null;
        }

        @Override
        public final Builder ebs(ScheduledInstancesEbs ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(ScheduledInstancesEbs.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        public final String getNoDevice() {
            return this.noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        public final String getVirtualName() {
            return this.virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        public ScheduledInstancesBlockDeviceMapping build() {
            return new ScheduledInstancesBlockDeviceMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduledInstancesBlockDeviceMapping> {
        public Builder deviceName(String var1);

        public Builder ebs(ScheduledInstancesEbs var1);

        default public Builder ebs(Consumer<ScheduledInstancesEbs.Builder> ebs) {
            return this.ebs((ScheduledInstancesEbs)((ScheduledInstancesEbs.Builder)ScheduledInstancesEbs.builder().apply(ebs)).build());
        }

        public Builder noDevice(String var1);

        public Builder virtualName(String var1);
    }
}

