/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.ResponseHostIdListCopier;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulItem;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulItemListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReleaseHostsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, ReleaseHostsResponse> {
    private final List<String> successful;
    private final List<UnsuccessfulItem> unsuccessful;

    private ReleaseHostsResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.unsuccessful = builder.unsuccessful;
    }

    public List<String> successful() {
        return this.successful;
    }

    public List<UnsuccessfulItem> unsuccessful() {
        return this.unsuccessful;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.successful());
        hashCode = 31 * hashCode + Objects.hashCode(this.unsuccessful());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReleaseHostsResponse)) {
            return false;
        }
        ReleaseHostsResponse other = (ReleaseHostsResponse)((Object)obj);
        return Objects.equals(this.successful(), other.successful()) && Objects.equals(this.unsuccessful(), other.unsuccessful());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.successful() != null) {
            sb.append("Successful: ").append(this.successful()).append(",");
        }
        if (this.unsuccessful() != null) {
            sb.append("Unsuccessful: ").append(this.unsuccessful()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successful": {
                return Optional.of(clazz.cast(this.successful()));
            }
            case "Unsuccessful": {
                return Optional.of(clazz.cast(this.unsuccessful()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<String> successful;
        private List<UnsuccessfulItem> unsuccessful;

        private BuilderImpl() {
        }

        private BuilderImpl(ReleaseHostsResponse model) {
            this.successful(model.successful);
            this.unsuccessful(model.unsuccessful);
        }

        public final Collection<String> getSuccessful() {
            return this.successful;
        }

        @Override
        public final Builder successful(Collection<String> successful) {
            this.successful = ResponseHostIdListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(String ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        public final void setSuccessful(Collection<String> successful) {
            this.successful = ResponseHostIdListCopier.copy(successful);
        }

        public final Collection<UnsuccessfulItem.Builder> getUnsuccessful() {
            return this.unsuccessful != null ? (Collection)this.unsuccessful.stream().map(UnsuccessfulItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemListCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(UnsuccessfulItem ... unsuccessful) {
            this.unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        public final void setUnsuccessful(Collection<UnsuccessfulItem.BuilderImpl> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemListCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public ReleaseHostsResponse build() {
            return new ReleaseHostsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, ReleaseHostsResponse> {
        public Builder successful(Collection<String> var1);

        public Builder successful(String ... var1);

        public Builder unsuccessful(Collection<UnsuccessfulItem> var1);

        public Builder unsuccessful(UnsuccessfulItem ... var1);
    }
}

