/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceLimitPrice;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PurchaseReservedInstancesOfferingRequest
extends EC2Request
implements ToCopyableBuilder<Builder, PurchaseReservedInstancesOfferingRequest> {
    private final Integer instanceCount;
    private final String reservedInstancesOfferingId;
    private final ReservedInstanceLimitPrice limitPrice;

    private PurchaseReservedInstancesOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.instanceCount = builder.instanceCount;
        this.reservedInstancesOfferingId = builder.reservedInstancesOfferingId;
        this.limitPrice = builder.limitPrice;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public String reservedInstancesOfferingId() {
        return this.reservedInstancesOfferingId;
    }

    public ReservedInstanceLimitPrice limitPrice() {
        return this.limitPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.limitPrice());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedInstancesOfferingRequest)) {
            return false;
        }
        PurchaseReservedInstancesOfferingRequest other = (PurchaseReservedInstancesOfferingRequest)((Object)obj);
        return Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.reservedInstancesOfferingId(), other.reservedInstancesOfferingId()) && Objects.equals(this.limitPrice(), other.limitPrice());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.reservedInstancesOfferingId() != null) {
            sb.append("ReservedInstancesOfferingId: ").append(this.reservedInstancesOfferingId()).append(",");
        }
        if (this.limitPrice() != null) {
            sb.append("LimitPrice: ").append(this.limitPrice()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceCount": {
                return Optional.of(clazz.cast(this.instanceCount()));
            }
            case "ReservedInstancesOfferingId": {
                return Optional.of(clazz.cast(this.reservedInstancesOfferingId()));
            }
            case "LimitPrice": {
                return Optional.of(clazz.cast(this.limitPrice()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private String reservedInstancesOfferingId;
        private ReservedInstanceLimitPrice limitPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedInstancesOfferingRequest model) {
            this.instanceCount(model.instanceCount);
            this.reservedInstancesOfferingId(model.reservedInstancesOfferingId);
            this.limitPrice(model.limitPrice);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getReservedInstancesOfferingId() {
            return this.reservedInstancesOfferingId;
        }

        @Override
        public final Builder reservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
            return this;
        }

        public final void setReservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
        }

        public final ReservedInstanceLimitPrice.Builder getLimitPrice() {
            return this.limitPrice != null ? this.limitPrice.toBuilder() : null;
        }

        @Override
        public final Builder limitPrice(ReservedInstanceLimitPrice limitPrice) {
            this.limitPrice = limitPrice;
            return this;
        }

        public final void setLimitPrice(ReservedInstanceLimitPrice.BuilderImpl limitPrice) {
            this.limitPrice = limitPrice != null ? limitPrice.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedInstancesOfferingRequest build() {
            return new PurchaseReservedInstancesOfferingRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, PurchaseReservedInstancesOfferingRequest> {
        public Builder instanceCount(Integer var1);

        public Builder reservedInstancesOfferingId(String var1);

        public Builder limitPrice(ReservedInstanceLimitPrice var1);

        default public Builder limitPrice(Consumer<ReservedInstanceLimitPrice.Builder> limitPrice) {
            return this.limitPrice((ReservedInstanceLimitPrice)((ReservedInstanceLimitPrice.Builder)ReservedInstanceLimitPrice.builder().apply(limitPrice)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

