/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.AttachmentStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceNetworkInterfaceAttachment
implements ToCopyableBuilder<Builder, InstanceNetworkInterfaceAttachment> {
    private final Instant attachTime;
    private final String attachmentId;
    private final Boolean deleteOnTermination;
    private final Integer deviceIndex;
    private final String status;

    private InstanceNetworkInterfaceAttachment(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.attachmentId = builder.attachmentId;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.deviceIndex = builder.deviceIndex;
        this.status = builder.status;
    }

    public Instant attachTime() {
        return this.attachTime;
    }

    public String attachmentId() {
        return this.attachmentId;
    }

    public Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public Integer deviceIndex() {
        return this.deviceIndex;
    }

    public AttachmentStatus status() {
        return AttachmentStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterfaceAttachment)) {
            return false;
        }
        InstanceNetworkInterfaceAttachment other = (InstanceNetworkInterfaceAttachment)obj;
        return Objects.equals(this.attachTime(), other.attachTime()) && Objects.equals(this.attachmentId(), other.attachmentId()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(this.deviceIndex(), other.deviceIndex()) && Objects.equals(this.statusString(), other.statusString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attachTime() != null) {
            sb.append("AttachTime: ").append(this.attachTime()).append(",");
        }
        if (this.attachmentId() != null) {
            sb.append("AttachmentId: ").append(this.attachmentId()).append(",");
        }
        if (this.deleteOnTermination() != null) {
            sb.append("DeleteOnTermination: ").append(this.deleteOnTermination()).append(",");
        }
        if (this.deviceIndex() != null) {
            sb.append("DeviceIndex: ").append(this.deviceIndex()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachTime": {
                return Optional.of(clazz.cast(this.attachTime()));
            }
            case "AttachmentId": {
                return Optional.of(clazz.cast(this.attachmentId()));
            }
            case "DeleteOnTermination": {
                return Optional.of(clazz.cast(this.deleteOnTermination()));
            }
            case "DeviceIndex": {
                return Optional.of(clazz.cast(this.deviceIndex()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant attachTime;
        private String attachmentId;
        private Boolean deleteOnTermination;
        private Integer deviceIndex;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterfaceAttachment model) {
            this.attachTime(model.attachTime);
            this.attachmentId(model.attachmentId);
            this.deleteOnTermination(model.deleteOnTermination);
            this.deviceIndex(model.deviceIndex);
            this.status(model.status);
        }

        public final Instant getAttachTime() {
            return this.attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final Integer getDeviceIndex() {
            return this.deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AttachmentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public InstanceNetworkInterfaceAttachment build() {
            return new InstanceNetworkInterfaceAttachment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceNetworkInterfaceAttachment> {
        public Builder attachTime(Instant var1);

        public Builder attachmentId(String var1);

        public Builder deleteOnTermination(Boolean var1);

        public Builder deviceIndex(Integer var1);

        public Builder status(String var1);

        public Builder status(AttachmentStatus var1);
    }
}

