/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetConsoleScreenshotRequest
extends EC2Request
implements ToCopyableBuilder<Builder, GetConsoleScreenshotRequest> {
    private final String instanceId;
    private final Boolean wakeUp;

    private GetConsoleScreenshotRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.wakeUp = builder.wakeUp;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Boolean wakeUp() {
        return this.wakeUp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.wakeUp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConsoleScreenshotRequest)) {
            return false;
        }
        GetConsoleScreenshotRequest other = (GetConsoleScreenshotRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.wakeUp(), other.wakeUp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.wakeUp() != null) {
            sb.append("WakeUp: ").append(this.wakeUp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "WakeUp": {
                return Optional.of(clazz.cast(this.wakeUp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String instanceId;
        private Boolean wakeUp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConsoleScreenshotRequest model) {
            this.instanceId(model.instanceId);
            this.wakeUp(model.wakeUp);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Boolean getWakeUp() {
            return this.wakeUp;
        }

        @Override
        public final Builder wakeUp(Boolean wakeUp) {
            this.wakeUp = wakeUp;
            return this;
        }

        public final void setWakeUp(Boolean wakeUp) {
            this.wakeUp = wakeUp;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetConsoleScreenshotRequest build() {
            return new GetConsoleScreenshotRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, GetConsoleScreenshotRequest> {
        public Builder instanceId(String var1);

        public Builder wakeUp(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

