/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.RouteTable;
import software.amazon.awssdk.services.ec2.model.RouteTableListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRouteTablesResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeRouteTablesResponse> {
    private final List<RouteTable> routeTables;

    private DescribeRouteTablesResponse(BuilderImpl builder) {
        super(builder);
        this.routeTables = builder.routeTables;
    }

    public List<RouteTable> routeTables() {
        return this.routeTables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTables());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouteTablesResponse)) {
            return false;
        }
        DescribeRouteTablesResponse other = (DescribeRouteTablesResponse)((Object)obj);
        return Objects.equals(this.routeTables(), other.routeTables());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.routeTables() != null) {
            sb.append("RouteTables: ").append(this.routeTables()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteTables": {
                return Optional.of(clazz.cast(this.routeTables()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<RouteTable> routeTables;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouteTablesResponse model) {
            this.routeTables(model.routeTables);
        }

        public final Collection<RouteTable.Builder> getRouteTables() {
            return this.routeTables != null ? (Collection)this.routeTables.stream().map(RouteTable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routeTables(Collection<RouteTable> routeTables) {
            this.routeTables = RouteTableListCopier.copy(routeTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTables(RouteTable ... routeTables) {
            this.routeTables(Arrays.asList(routeTables));
            return this;
        }

        public final void setRouteTables(Collection<RouteTable.BuilderImpl> routeTables) {
            this.routeTables = RouteTableListCopier.copyFromBuilder(routeTables);
        }

        @Override
        public DescribeRouteTablesResponse build() {
            return new DescribeRouteTablesResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeRouteTablesResponse> {
        public Builder routeTables(Collection<RouteTable> var1);

        public Builder routeTables(RouteTable ... var1);
    }
}

