/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedInstancesListingsRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DescribeReservedInstancesListingsRequest> {
    private final List<Filter> filters;
    private final String reservedInstancesId;
    private final String reservedInstancesListingId;

    private DescribeReservedInstancesListingsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.reservedInstancesListingId = builder.reservedInstancesListingId;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public String reservedInstancesId() {
        return this.reservedInstancesId;
    }

    public String reservedInstancesListingId() {
        return this.reservedInstancesListingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesListingId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesListingsRequest)) {
            return false;
        }
        DescribeReservedInstancesListingsRequest other = (DescribeReservedInstancesListingsRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.reservedInstancesId(), other.reservedInstancesId()) && Objects.equals(this.reservedInstancesListingId(), other.reservedInstancesListingId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.reservedInstancesId() != null) {
            sb.append("ReservedInstancesId: ").append(this.reservedInstancesId()).append(",");
        }
        if (this.reservedInstancesListingId() != null) {
            sb.append("ReservedInstancesListingId: ").append(this.reservedInstancesListingId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "ReservedInstancesId": {
                return Optional.of(clazz.cast(this.reservedInstancesId()));
            }
            case "ReservedInstancesListingId": {
                return Optional.of(clazz.cast(this.reservedInstancesListingId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private String reservedInstancesId;
        private String reservedInstancesListingId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesListingsRequest model) {
            this.filters(model.filters);
            this.reservedInstancesId(model.reservedInstancesId);
            this.reservedInstancesListingId(model.reservedInstancesListingId);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getReservedInstancesId() {
            return this.reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final String getReservedInstancesListingId() {
            return this.reservedInstancesListingId;
        }

        @Override
        public final Builder reservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
            return this;
        }

        public final void setReservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedInstancesListingsRequest build() {
            return new DescribeReservedInstancesListingsRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DescribeReservedInstancesListingsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder reservedInstancesId(String var1);

        public Builder reservedInstancesListingId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

